/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15250, function(sym, e) {
         sym.stop();
         sym.getSymbol("ship").getSymbol("sup_ufo").play("loop");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_btnBegin}", "click", function(sym, e) {
         sym.play("pretest");

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the composition is fully loaded here
         
         //$("<input type='text' id='Firstname' name='first_name'  tabindex='1' maxlength='15' style='background-color:white; border:1px solid black' required>").appendTo(sym.$("box"));
         
         
         sym.$("NEXT").bind("click",function(){
            sym.play();
         });

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_sym_table}", "click", function(sym, e) {
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 16000, function(sym, e) {
         
         function widthWindow(){
         	nowWidth = $(document).width();
         	return nowWidth;
         }
         
         
         var ship = sym.$("ship");
         var dbShip = sym.getSymbol("ship").$("db");
         var targetDb = sym.getSymbol("ship").getSymbol("db");
         var tempArray = [];
         var dataTemp=[];
         var dataSea=[];
         var j =1;
         var h =0;
         var tempText="";
         var seaText="";
         var table = sym.getSymbol("sym_table");
         var firstTime = false;
         for(var i=1;i<=10;i++){
         		sym.$("btn_"+i).bind("click",function(){
         			//console.log(this);
         			 var posX = sym.$(this).position().left;
         			 var posY = sym.$(this).position().top;
         			 var currBtnWidth = sym.$(this).width();
         			 var currBtnHeight = sym.$(this).height();
         			 moveShip(posX,posY,this.id,currBtnWidth,currBtnHeight);
         			 TweenMax.to(dbShip,0.3,{css:{scaleX:"0%",scaleY:"0%"},ease:Quad.easeOut});
         
         		});
         }
         
         
         function showDbox(target){
         
         	if(target >8){
         		//console.log(targetDb.$("detailBox"));
         		targetDb.$("detailBox").hide();
         		targetDb.$("detailBox2").show();
         		TweenMax.to(dbShip,0.4,{css:{scaleX:"1%",scaleY:"1%",top:50,left:20,transformOrigin:"11% 0"},ease:Back.easeOut});
         	}else{
         		console.log("less");
         		targetDb.$("detailBox").show();
         		targetDb.$("detailBox2").hide();
         		TweenMax.to(dbShip,0.4,{css:{scaleX:"1%",scaleY:"1%",top:-161,left:0,transformOrigin:"11% 99%"},ease:Back.easeOut});
         	}
         	targetDb.stop("d"+target);
         }
         function moveShip(getX,getY,getI,boxW,boxH){
         		var treuPosw = boxW - 40;
         		var treuPosh = getY - (boxH /2.2);
         		var res = getI.substring(10)
         		var numFlag = parseInt(res);
         		var widthWin = widthWindow();
         		if(widthWin <=1024){
         			TweenMax.to(ship,1.2,{css:{x:getX+treuPosw,y:treuPosh+30},onComplete:showDbox,onCompleteParams:[numFlag],ease:Quad.easeOut});
         		}else{
         			TweenMax.to(ship,1.2,{css:{x:getX+treuPosw,y:treuPosh},onComplete:showDbox,onCompleteParams:[numFlag],ease:Quad.easeOut});
         		}
         		
         		switch(numFlag){
         			case 1: seaText="0";tempText="30";
         			break;
         			case 2: seaText="1000";tempText="23";
         			break;
         			case 3: seaText="3000";tempText="8";
         			break;
         			case 4: seaText="15000";tempText="-65";
         			break;
         			case 5: seaText="30000";tempText="-46";
         			break;
         			case 6: seaText="50000";tempText="-25";
         			break;
         			case 7: seaText="80000";tempText="-74";
         			break;
         			case 8: seaText="100000";tempText="-70";
         			break;
         			case 9: seaText="200000";tempText="500";
         			break;
         			case 10: seaText="300000";tempText="600";
         			break;
         		}
         
         		parseText(res,seaText,tempText);
         }
         
         
         function parseText(idc,seam,tempm){
         	var bool = arraysEqual(idc);
         	var sea = 'sea_'+j;
         	var temp = 'temp_'+j;
         
         	if(bool){
         		console.log("true");
         		//console.log("tempA = "+tempArray);
         		tempArray.push(idc);
         		dataTemp.push(tempm);
         		dataSea.push(seam);
         		console.log("dataTemp = "+dataTemp+"\n"+"dataSea = "+dataSea);
         
         		if(j<=10){
         			table.$(sea).html(seaText);
         			table.$(temp).html(tempText);
         			h+=1;
         		}
         		j++;
         
         	}else{
         	   console.log("false");
         	   console.log("not record");
         	}
         
         	if(!firstTime){
         		setTimeout(function(){showTable();},1000);
         		firstTime = true;
         	} 
         
         }
         
         function arraysEqual(a) {
           if(tempArray.length>10) return false;
         
           for (var i = 0; i < tempArray.length; ++i) {
             if (a == tempArray[i]) return false;
           }
           return true;
         }
         function showTable(){
         	var element = sym.$("sym_table");
         	var foo = sym.getVariable("showed");
         	var stageWidth = sym.$("Stage").width();
         	var tableWidth = element.width();
         	sym.setVariable("showed","false");
         	if(foo == "true"){
         		TweenMax.to(element,1,{css:{x:stageWidth-55},ease:Quad.easeOut});
         		sym.setVariable("showed","false");
         	}else{
         		TweenMax.to(element,1,{css:{x:stageWidth-tableWidth},ease:Quad.easeOut});
         		sym.setVariable("showed","true");
         	}
         }
         
         table.$('btn_table').bind("click",function(){
         	 showTable();
         });
         
         sym.stop();

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 16396, function(sym, e) {
         
         //Choice 1
         sym.$('btn_yes').bind("click",function(){
         	worng();
         });
         
         sym.$('btn_no').bind("click",function(){
         	correct(1);
         });
         
         
         //Choice 1
         sym.$('btn_yes2').bind("click",function(){
         	worng();
         });
         
         sym.$('btn_no2').bind("click",function(){
         	correct(2);
         });
         
         
         function correct(target){
         	if(target == 1 ){
         		sym.getSymbol("solution").play("correct");
         	}else{
         		sym.getSymbol("solution").play("correct2");
         	}
         	
         }
         function worng(){
         	sym.getSymbol("solution").play("wrong");
         }
         

      });
      //Edge binding end

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         yepnope({
             load: [
         		"js/edgedock/js/min/EdgeCommons.js",
         		"js/alertifyjs/alertify.min.js",
         		"js/TweenMax.min.js",
         		"js/energize.js",
         		"js/alertifyjs/css/alertify.min.css",
         		"js/alertifyjs/css/themes/default.min.css",
         		"js/edgedock/css/style.css"
         	],
         	complete: function () {
         
              console.log("allscript complete");
              sym.play();
              sym.getSymbol("ship").play();
           }
         });
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'mascot'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.playReverse();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("mascot");
   //Edge symbol end:'mascot'

   //=========================================================
   
   //Edge symbol: 'btnBegin'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         // Play the timeline at a label or specific time. For example:
         // sym.play(500); or sym.play("myLabel");
         sym.play(0);

      });
      //Edge binding end

   })("btnBegin");
   //Edge symbol end:'btnBegin'

   //=========================================================
   
   //Edge symbol: 'box'
   (function(symbolName) {   
   
   })("box");
   //Edge symbol end:'box'

   //=========================================================
   
   //Edge symbol: 'sym_table'
   (function(symbolName) {   
   
   })("sym_table");
   //Edge symbol end:'sym_table'

   //=========================================================
   
   //Edge symbol: 'shipland'
   (function(symbolName) {   
   
      

      

   })("shipland");
   //Edge symbol end:'shipland'

   //=========================================================
   
   //Edge symbol: 'graphBox'
   (function(symbolName) {   
   
   })("graphBox");
   //Edge symbol end:'graphBox'

   //=========================================================
   
   //Edge symbol: 'db'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("db");
   //Edge symbol end:'db'

   //=========================================================
   
   //Edge symbol: 'sup_ufo'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.playReverse();

      });
      //Edge binding end

   })("sup_ufo");
   //Edge symbol end:'sup_ufo'

   //=========================================================
   
   //Edge symbol: 'btn_yes'
   (function(symbolName) {   
   
   })("btn_yes");
   //Edge symbol end:'btn_yes'

   //=========================================================
   
   //Edge symbol: 'btn_no'
   (function(symbolName) {   
   
   })("btn_no");
   //Edge symbol end:'btn_no'

   //=========================================================
   
   //Edge symbol: 'solution'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3376, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("solution");
   //Edge symbol end:'solution'

})(jQuery, AdobeEdge, "EDGE-14082424");