/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the composition is fully loaded here
         
         function widthWindow(){
         	nowWidth = $(document).width();
         	return nowWidth;
         }  
         
         var j = 1;
         var ship = sym.$("ship");
         var detail = "";
         var table = sym.getSymbol("sym_table");
         
         var boolf = false;
         var tempFlag="";
         var tempNumFlag;
         
         var tempArray =[];
         
         var countryText="";
         var nightText="";
         var dayText="";
         
         var firstTime = false;
         
         for(var i=1;i<=14;i++){
         		sym.$("btn_"+i).bind("click",function(){
         			 var posX = sym.$(this).position().left;
         			 var posY = sym.$(this).position().top;
         			 var res = this.id.substring(10);
         			 moveShip(posX,posY,this.id);
         		});
         }
         
         function moveShip(getX,getY,getI){
         
         
         
         
         		var res = getI.substring(10)
         		var numFlag = parseInt(res);
               var flag = sym.$("c"+numFlag);
               var widthWin = widthWindow();
         		console.log(numFlag);
         		sym.$("btn_"+numFlag).hide();
         		sym.$("btn_"+tempNumFlag).show();
         
         		if(widthWin <=1024){
         				if(numFlag == 1 || numFlag == 8 || numFlag == 10 || numFlag == 12){
         						TweenMax.to(ship,1.2,{css:{x:getX-30,y:getY+70},ease:Quad.easeOut});
         				}else if(numFlag == 5){
         						TweenMax.to(ship,1.2,{css:{x:getX+10,y:getY+40},ease:Quad.easeOut});
         				}else{
         						TweenMax.to(ship,1.2,{css:{x:getX,y:getY+40},ease:Quad.easeOut});
         				}
         		}else{
         				if(numFlag == 1 || numFlag == 8 || numFlag == 10 || numFlag == 12){
         				TweenMax.to(ship,1.2,{css:{x:getX-50,y:getY+55},ease:Quad.easeOut});
         				}else if(numFlag == 5){
         						TweenMax.to(ship,1.2,{css:{x:getX+10,y:getY+20},ease:Quad.easeOut});
         				}else{
         						TweenMax.to(ship,1.2,{css:{x:getX-20,y:getY+10},ease:Quad.easeOut});
         				}
         		}
         
         
         			if(tempFlag!=flag){
         					TweenMax.to(flag,.8,{css:{scaleX:"1%",scaleY:"1%"},ease:Back.easeOut});
         					TweenMax.to(tempFlag,1.2,{css:{scaleX:"0%",scaleY:"0%"},ease:Quad.easeOut});
         					tempFlag = flag;
         			}		
         
         			tempNumFlag = numFlag;
         
         		switch(numFlag){
         			case 1: countryText="สหรัฐอเมริกา";dayText="0";nightText="-4";
         			break;
         			case 2: countryText="สหรัฐอเมริกา";dayText="19";nightText="23";
         			break;
         			case 3: countryText="เม็กซิโก";dayText="9";nightText="13";
         			break;
         			case 4: countryText="บราซิล";dayText="23";nightText="29";
         			break;
         			case 5: countryText="อังกฤษ";dayText="6";nightText="8";
         			break;
         			case 6: countryText="อิสราเอล";dayText="7";nightText="12";
         			break;
         			case 7: countryText="แอฟริกาใต้";dayText="22";nightText="28";
         			break;
         			case 8: countryText="ฟินแลนด์";dayText="4";nightText="4";
         			break;
         			case 9: countryText="อียิปต์";dayText="10";nightText="18";
         			break;
         			case 10: countryText="ฝรั่งเศส";dayText="7";nightText="14";
         			break;
         			case 11: countryText="พม่า";dayText="10";nightText="28";
         			break;
         			case 12: countryText="จีน";dayText="-10";nightText="-2";
         			break;
         			case 13: countryText="ญี่ปุ่น";dayText="5";nightText="8";
         			break;
         			case 14: countryText="ออสเตรเลีย";dayText="16";nightText="22";
         			break;
         
         		}
         
         		parseText(res);
         }
         
         
         function parseText(idc){
         	var bool = arraysEqual(idc);
         	var atList = 'text'+j;
         	var contry = 'con'+j;
         	var day = 'day'+j;
         	var night = 'night'+j;
         
         	if(bool){
         		console.log("true");
         		console.log("tempA = "+tempArray);
         		tempArray.push(idc);
         		if(j<=5){
         			table.$(atList).html(j);
         			table.$(contry).html(countryText);
         			table.$(day).html(dayText);
         			table.$(night).html(nightText);
         		}
         		j++;
         
         	}else{
         	   console.log("false");
         	   console.log("not record");
         	}
         
         	if(!firstTime){
         		setTimeout(function(){showTable();},1000);
         		firstTime = true;
         	} 
         
         }
         
         function arraysEqual(a) {
           if(tempArray.length>4) return false;
         
           for (var i = 0; i < tempArray.length; ++i) {
             if (a == tempArray[i]) return false;
           }
           return true;
         }
         function showTable(){
         
         	var element = sym.$("sym_table");
         	var foo = sym.getVariable("showed");
         	var stageWidth = sym.$("Stage").width();
         	var tableWidth = element.width();
         	sym.setVariable("showed","false");
         	if(foo == "true"){
         		TweenMax.to(element,1,{css:{x:stageWidth-55},ease:Quad.easeOut});
         		sym.setVariable("showed","false");
         	}else{
         		TweenMax.to(element,1,{css:{x:stageWidth-tableWidth},ease:Quad.easeOut});
         		sym.setVariable("showed","true");
         	}
         }
         sym.$('btn_next').bind("click",function(){
         	TweenMax.to(ship,2,{css:{x:-200,y:-200},ease:Quad.easeOut});
         	TweenMax.to(tempFlag,1.2,{css:{scaleX:"0%",scaleY:"0%"},ease:Quad.easeOut});
         	sym.play('s2');
         	var foo = sym.getVariable("showed");
         	if(foo == "true")showTable();
         });
         sym.$('sym_table').bind("mousedown",function(){
         	 showTable();
         });
         
         

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         
         //input massage
         var answer = sym.$("answer");
         inputMessage = $('<textarea />').attr({'type':'textarea','rows':'3','value':'', 'id':'message'});
         inputMessage.css ('line-height', 2.5);
         inputMessage.css ('font-size', 18);
         inputMessage.css ('color', '#ffffff');
         inputMessage.css ('resize', 'none');
         inputMessage.css ('background-color', 'transparent');
         inputMessage.css ('border', 0);
         inputMessage.css ('box-shadow', 'transparent');
         inputMessage.css ('width', 320);
         inputMessage.css ('height', 100);
         inputMessage.appendTo(answer);
         
         //check Choice
         var tempBtn = "test";
         var boolf = false;
         var choosed=0;
         
         function enable(btncurr){
         	sym.getSymbol(btncurr).stop("out");
         
         	sym.$(btncurr).bind("click", function(){
         			disable(btncurr);
         	});
         
         	//console.log("btncurr = "+btncurr);
         }
         
         function disable(btnch,fid) {   
         					sym.getSymbol(btnch).stop("over");
                   		sym.$(btnch).unbind("click");
         				   var res = fid.substring(13);
                  		var intRes = parseInt(res);
                  		choosed = intRes;
                  		console.log(res);
         					if(boolf){
         							if(tempBtn!=btnch){
         									//console.log("true");
         									enable(tempBtn);
         							}else{
         									//console.log("false");
         
         							}
         					}else{
         					   boolf = true;
         
         					}
         
                   		tempBtn = btnch;
                   		//console.log("tempBtn = " + tempBtn);
               }
         
         for(var s=1;s<=3;s++){
         		sym.$("btn_q1_"+s).bind("click",function(){
         			console.log("clicked");
         			disable(this,this.id);
         		});
         }
         
         function checkAns(){
         	var contentText = message.value; 
         	if(contentText == ''){
         		return false;
         	}else{
         		return true
         	}
         }
         
         
         
         
         sym.$('checkAns1').bind("click",function(){
         	var ifdone = checkAns();
         	if(ifdone){
         		sym.getSymbol("mascot_show").play('l3');
         	}else{
         		alertify.alert("เกิดข้อผิดพลาด","กรุณาเติมคำลงในช่องว่าง").setting({transition:'fade'}).show();
         	}
         });
         sym.$('checkAns2').bind("click",function(){
         
         	if(choosed == 1){
         		sym.getSymbol("mascot_show").play('l1');
         	}else if(choosed == 2){
         		sym.getSymbol("mascot_show").play('l2');
         	}else if(choosed == 3){
         		sym.getSymbol("mascot_show").play('l2');
         	}else{
         		alertify.alert("เกิดข้อผิดพลาด","ยังทำแบบฝึกหัดไม่ครบทุกข้อเลย").setting({transition:'fade'}).show();
         	}
         })

      });
      //Edge binding end

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         yepnope({
             load: [
         		"js/edgedock/js/min/EdgeCommons.js",
         		"js/alertifyjs/alertify.min.js",
         		"js/TweenMax.min.js",
         		"js/energize.js",
         		"js/alertifyjs/css/alertify.min.css",
         		"js/alertifyjs/css/themes/default.min.css",
         		"js/edgedock/css/style.css"
         	],
         	complete: function () {
         
              console.log("allscript complete");
              sym.play();
           }
         });
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'sym_table'
   (function(symbolName) {   
   
   })("sym_table");
   //Edge symbol end:'sym_table'

   //=========================================================
   
   //Edge symbol: 'c1'
   (function(symbolName) {   
   
   })("c1");
   //Edge symbol end:'c1'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'btn_q1_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("btn_q1_1");
   //Edge symbol end:'btn_q1_1'

   //=========================================================
   
   //Edge symbol: 'btn_q1_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("btn_q1_2");
   //Edge symbol end:'btn_q1_2'

   //=========================================================
   
   //Edge symbol: 'btn_q1_3'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("btn_q1_3");
   //Edge symbol end:'btn_q1_3'

   //=========================================================
   
   //Edge symbol: 'mascot_show'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1292, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4554, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("mascot_show");
   //Edge symbol end:'mascot_show'

})(jQuery, AdobeEdge, "EDGE-177854967");