
/**
 * Module dependencies.
 */

var crypto = require('crypto');

/**
 * Return a weak ETag from the given `path` and `stat`.
 *
 * @param {String} path
 * @param {Object} stat
 * @return {String}
 * @api private
 */

exports.etag = function etag(path, stat) {
  var tag = String(stat.mtime.getTime()) + ':' + String(stat.size) + ':' + path;
  var str = crypto
    .createHash('md5')
    .update(tag, 'utf8')
    .digest('base64');
  return 'W/"' + str + '"';
};

/**
 * decodeURIComponent.
 *
 * Allows V8 to only deoptimize this fn instead of all
 * of send().
 *
 * @param {String} path
 * @api private
 */

exports.decode = function(path){
  try {
    return decodeURIComponent(path);
  } catch (err) {
    return -1;
  }
};
