var gulp = require('gulp'),
	browserSync = require('browser-sync'),
	reload = browserSync.reload,
	sass = require('gulp-sass');
	
// Static Server
gulp.task('browser-sync', function() {
	browserSync({
		server: {
			baseDir: "./"
		}
	});
});

gulp.task('sass', function (){
	return gulp.src('dev/css/*.scss')
	.pipe(sass({
            compass: true, // ใช้ Compass 
            style: 'compressed', // เลือก output แบบ compressed
        }))
        .on('error', function (err) { 
            console.log(err.message); 
        })
        .pipe(gulp.dest('public/css')) // เก็บไฟล์ css ไว้ที่โฟลเดอร์ css
});

// Default task to be run with 'gulp'
gulp.task('default', ['sass', 'browser-sync'], function(){
	// เมื่อไฟล์ html หรือ css มีการเปลี่ยนแปลง ก็ให้รีเฟรช web browser
    gulp.watch(['**/*.html'], browserSync.reload);
    gulp.watch(['public/css/*.css'], browserSync.reload);
	
	gulp.watch("dev/css/*.scss", ['sass']);
});