var userScore = 0;
var exitPageStatus = false;

function doLMSInitialize(){
	return doInitialize();
}

function doLMSFinish(){
	return doTerminate();
}

function doLMSGetValue(name){
	name = doTranslateRTE( name );
	if(name != null && typeof(name) == 'object') name = name[0];

	if(name != null) return doGetValue( name );
	return null;
}

function doLMSSetValue(name, value){

	var data = doTranslateRTE( name, value );
	name = data[0];
	value = data[1];
	if(name != null && value != null) return doSetValue( name , value);
	return null;
}

function doTranslateRTE(name, value){
	if((value == null) || (typeof(value) == 'undefined')) value = null;

	switch(name.toLowerCase()){
		case 'cmi.core.lesson_location':
			name = 'cmi.location';
			break;
		case 'cmi.core.lesson_status':
			name = 'cmi.completion_status';
			break;
		case 'cmi.core.lesson_mode':
			name = 'cmi.mode';
			break;
		case 'cmi.core.credit':
			name = 'cmi.credit';
			break;
		case 'cmi.suspend_data':
			name = null;
			break;
		case 'cmi.core.score.raw':
			if(value != null) userScore = value;
			if(value != null) doSetValue('cmi.score.raw', value);

			name = 'cmi.score.scaled';
			if(value != null) value = (value / 50) - 1;
			break;
		default:
			/*
			name = null;
			if(value != null) value = '';
			*/
			break;
	}

	return (value != null)?[name, value]:name;
}

function doLMSCommit(){
	return doCommit();
}

function unloadPage( status )
{

	if (exitPageStatus != true)
	{
		result = doQuit( status );
	}

	// NOTE:  don't return anything that resembles a javascript
	//		  string from this function or IE will take the
	//		  liberty of displaying a confirm message box.
	
	return result;
}


function doQuit( status )
{
   computeTime();
   exitPageStatus = true;
   
   var result;

   result = doLMSCommit();

   result = doLMSSetValue("cmi.core.lesson_status", status);

	nolptime_stop = true;
   setSessionTime();

   result = doLMSFinish();
   return result;
}

function startTimer(){
}

function computeTime(){
}

function setSessionTime(){
	if(typeof(nolptime) != 'undefined' && typeof(nolptime_stop) != 'undefined'){
		var nolptime_value = nolptime.split(':');
		var sessiontime_value = 'PT';
		if(nolptime_value[0] != '00') sessiontime_value += nolptime_value[0]+'H';
		if(nolptime_value[1] != '00') sessiontime_value += nolptime_value[1]+'M';
		if(nolptime_value[2] != '00') sessiontime_value += nolptime_value[2]+'S';
		//alert(sessiontime_value);
		doSetValue("cmi.session_time", sessiontime_value);

		//setTimeout("setSessionTime()", 5000);
	}
}