<?php

  require_once("../shared/common.php");
  require_once("../shared/logincheck.php");

  $tab = "cataloging";
  $nav = "autority_control";

  require_once("../shared/header.php");
  require_once("../functions/searchFuncs.php");
  require_once("../classes/AuthorityQuery.php");
  require_once("../classes/Localize.php");

  $loc = new Localize(OBIB_LOCALE, $tab);
  $locsh = new Localize(OBIB_LOCALE, "shared");

	switch ($_GET['type']) {
	case 'author' :// author
	case 'publisher' :// publisher
	case 'series' :// series
	case 'topic' :// topic
		$type = $_GET['type'];
		break;
	default :
		header("Location: ../catalog/authority.php");
		exit();
	}
  if ($_SERVER['REQUEST_METHOD'] == "POST" && $_POST['action_merge'] == true) {
	$authorityQ = new AuthorityQuery();
	$authorityQ->connect();
	if ($authorityQ->errorOccurred()) {
		$authorityQ->close();
		displayErrorPage($authorityQ);
	} else {
	
		if (isset($_POST["authorityText1"])) {
			$old = $_POST["authorityText1"];
		} else {
			$msg .= $loc->getText("authorityRequireControl1")."<br>";
		}
		if (isset($_POST["authorityText2"])) {
			$new = $_POST["authorityText2"];
		} else {
			$msg .= $loc->getText("authorityRequireControl2")."<br>";
		}
		if (isset($_POST["authority"])) {
			$authority = $_POST["authority"];
		} else {
			$msg .= $loc->getText("authorityRequireControl2")."<br>";
		}
		if ($msg == "") {
			$authorityQ->update($authority,$new,$old);
			$authorityQ->close();
			$msg .= $loc->getText("authorityMergeSuccess");
		}
	}

    echo '<div id="message"><font class="error">';
    echo $msg;
    echo '</font></div>';
  }

?>

<h1><?php echo $loc->getText("authorityHddr");?></h1>
<form name="authoritymerge" method="POST" action="">
<table class="primary">
  <tr>
    <th valign="top" nowrap="yes" align="left">
      <?php echo $loc->getText("authorityControl");?>: <?php echo $loc->getText("authorityControl".ucfirst($type));?>
    </th>
  </tr>
  <tr>
    <td nowrap="true" class="primary">
      <?php echo $loc->getText("authorityControl1");?>:
      <input type="text" name="authorityText1" id="authorityText1" size="20" maxlength="500" readonly>
	   <input type="button" class="button" id="authority_control" name="authority_control" value="<?php echo $loc->getText('authority'); ?>" onclick="popSecondary('../catalog/biblio_authority.php?page=<?php echo $type; ?>&id=authorityText1')" />
    </td>
  </tr>
  <tr>
    <td nowrap="true" class="primary">
      <?php echo $loc->getText("authorityControl2");?>:
      <input type="text" name="authorityText2" id="authorityText2" size="20" maxlength="500">
	   <input type="button" class="button" id="authority_control" name="authority_control" value="<?php echo $loc->getText('authority'); ?>" onclick="popSecondary('../catalog/biblio_authority.php?page=<?php echo $type; ?>&id=authorityText2')" />
    </td>
  </tr>
  <tr>
    <td nowrap="true" class="primary" align="center">
      <input type="submit" value="<?php echo $loc->getText("authorityMerge");?>" class="button">
    </td>
  </tr>
</table>
<input type="hidden" name="authority" value="<?php echo $type; ?>" />
<input type="hidden" name="action_merge" value="true" />
</form>

<?php
  include("../shared/footer.php");
?>