<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  include("../shared/authority_header.php");
  require_once("../classes/AuthorityQuery.php");
  require_once("../classes/Localize.php");
  $tab = "cataloging";

  $loc = new Localize(OBIB_LOCALE, $tab);
  $locsh = new Localize(OBIB_LOCALE, "shared");
 
  if (isset($_GET["page"])) {
    $sType = $_GET["page"];
  } else {
    $sType = "author";
  }
  if (isset($_GET["id"])) {
    $id = $_GET["id"];
  }
  if (isset($_POST["searchText"])) {
    $words = $_POST["searchText"];
  } else {
    $words = "";
  }
  if (preg_match('/^[a-zA-Z0-9_]+$/', $page)) {
#    include("../locale/".OBIB_LOCALE."/help/".$page.".php");
  }

  $authorityQ = new AuthorityQuery();
  $authorityQ->setItemsPerPage(20);
  $authorityQ->connect();
  if ($authorityQ->errorOccurred()) {
    $authorityQ->close();
    displayErrorPage($authorityQ);
  }

#  $sType = 'author';
#  $words = '';
  $currentPageNmbr = isset($_POST["page"]) ? $_POST["page"] : 1;
  $sortBy = 'authority';
  if (!$authorityQ->search($sType, $words, $currentPageNmbr, $sortBy)) {
    $authorityQ->close();
    displayErrorPage($authorityQ);
  }

?>
<script type="text/javascript">
function changePage(page,sort) {
  document.changePageForm.page.value = page;
  document.changePageForm.sortBy.value = sort;
  document.changePageForm.searchText.value = document.changePageForm.inputSearch.value;
  document.changePageForm.submit();
}
function newSearch() {
  document.changePageForm.page.value = 1;
  document.changePageForm.searchText.value = document.changePageForm.inputSearch.value;
  document.changePageForm.submit();
}
</script>

<form name="changePageForm" method="POST" action="" onsubmit="newSearch();">
<input type="hidden" name="searchType" value="<?php echo $sType ?>" />
<input type="hidden" name="searchText" value="<?php echo $words; ?>" />
<input type="hidden" name="sortBy" value="<?php echo $sort ?>" />
<input type="hidden" name="page" value="1" />

<table class="primary">
	<tr>
		<th>
		  <?php echo $loc->getText("authoritySearch");?> :
		</th>
	</tr>
	<tr>
		<td align="right"><?php echo $loc->getText("indexButton");?> :
			<input type="text" name="inputSearch" value="<?php echo $words; ?>">
			<input type="button" value="<?php echo $loc->getText("indexButton");?>" title="<?php echo $loc->getText("indexButton");?>" class="button" onclick="newSearch();">
		</td>
	</tr>
</table>
<br>
<table class="primary">
	<tr>
		<th width="75%"><?php echo $loc->getText("authorityControl".ucfirst($sType));?></th>
		<th align="center"><?php echo $loc->getText("authorityTotal");?></th>
	</tr>
<?php
  if ($authorityQ->getRowCount() == 0) { // IFELSE 1
    $authorityQ->close();
?>
	<tr>
		<td colspan="2" align="center"><?php echo $loc->getText("authoritySearchNoResults"); ?></td>
	</tr>
<?php
  } else {
    while ($authority = $authorityQ->_conn->fetchRow()) {
      if (isset($_GET["id"])) {
?>
	<tr onclick="javascript: opener.document.getElementById('<?php echo $id; ?>').value='<?php echo $authority['authority']; ?>'; window.close();" style="cursor:hand;">
		<td class="primary"><?php echo $authority['authority']; ?></td>
		<td class="primary" align="center"><?php echo $authority['total']; ?></td>
	</tr>
<?php
      } else {
?>
	<tr>
		<td class="primary"><?php echo $authority['authority']; ?></td>
		<td class="primary" align="center"><?php echo $authority['total']; ?></td>
	</tr>
<?php
      }
    }
  }
?>
</table>
</form>
<?php

  function printResultPages(&$loc, $currPage, $pageCount, $sort) {
    if ($pageCount <= 1) {
      return false;
    }
    echo $loc->getText("biblioSearchResultPages").": ";
    $maxPg = OBIB_SEARCH_MAXPAGES;
    if ($maxPg % 2 == 0) $maxPg++;
    $borderPg = ($maxPg - 1) / 2;
    
    if ($maxPg > $pageCount) {
      $startPg = 1;
      $endPg = $pageCount;
    }
    else {
      if ($currPage - $borderPg < 1) {
        $startPg = 1;
        $endPg = $maxPg;
      }
      elseif ($currPage + $borderPg > $pageCount) {
        $endPg = $pageCount;
        $startPg = $endPg - $maxPg + 1;
      }
      else {
        $startPg = $currPage - $borderPg;
        $endPg = $currPage + $borderPg;
      }
    }

    if ($currPage > 1) {
      echo "<a href=\"javascript:changePage(1,'".H(addslashes($sort))."')\">&laquo;".$loc->getText("biblioSearchFirst")."</a> ";
      echo "<a href=\"javascript:changePage(".H(addslashes($currPage-1)).",'".H(addslashes($sort))."')\">&lsaquo;".$loc->getText("biblioSearchPrev")."</a> ";
    }
    for ($i = $startPg; $i <= $endPg; $i++) {
      if ($i == $currPage) {
        echo "<b>".H($i)."</b> ";
      } else {
        echo "<a href=\"javascript:changePage(".H(addslashes($i)).",'".H(addslashes($sort))."')\">".H($i)."</a> ";
      }
    }
    if ($currPage < $pageCount) {
      echo "<a href=\"javascript:changePage(".($currPage+1).",'".$sort."')\">".$loc->getText("biblioSearchNext")."&rsaquo;</a> ";
      echo "<a href=\"javascript:changePage(".$pageCount.",'".$sort."')\">".$loc->getText("biblioSearchLast")."&raquo;</a> ";
    }
  }

  echo "<div id=\"pagination\">"; 
  printResultPages($locsh, $currentPageNmbr, $authorityQ->getPageCount(), $sortBy);
  echo "</div>"; 

  include("../shared/help_footer.php");
?>