<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
  require_once("../shared/common.php");
  require_once("../classes/Member.php");
  require_once("../classes/MemberQuery.php");
  require_once("../functions/inputFuncs.php");
  require_once("../classes/Localize.php");
  require_once("../classes/Query.php");

  $tab = "circulation";
  $nav = "csv_import";

  include("../shared/header.php");
  include("../shared/logincheck.php");

  $loc = new Localize(OBIB_LOCALE, $tab);
  $locCatalog = new Localize(OBIB_LOCALE, "cataloging");

  if ($_SERVER['REQUEST_METHOD'] == "POST") {
    $filename = basename($_FILES['upload']['name']);
    $uploadfile = sys_get_temp_dir() . "/" . $filename;
    if (move_uploaded_file($_FILES['upload']['tmp_name'], $uploadfile)) {
      $rows = array();
      $cols = array();
      $row_count = 1;
#	  setlocale ( LC_ALL, 'en_US.UTF-8' );
      if (($handle = fopen($uploadfile, "r")) !== FALSE) {
        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
          $row = array();
          $num = count($data);
          for ($c = 0; $c < $num; $c++) {
            if ($row_count == 1) {
              // Header
              $cols[] = str_replace('"','',$data[$c]);
            } else {
              $row[$cols[$c]] = $data[$c];
            }
          }
          if (count($row) > 0) {
            $rows[] = $row;
          }
          $row_count++;
        }
        fclose($handle);

        // Save to the database
        foreach ($rows as $mbr_row) {
          $member = new Member();
#          $member->setMbrid($row['mbrid']);
          if ($mbr_row['barcode_nmbr'] == "") {
		    $nzeros = "5";
		    $barcode = "0";
		    $sql = "SELECT MAX(barcode_nmbr) AS bn FROM member"; 
		    $q = new Query(); 
		    $barcode_rows = $q->exec($sql);
		    if (count($barcode_rows) > 0) {
		      $barcode = $barcode_rows[0]["bn"];
		    }
		    $q->close();
		    $barcode++;
		    $barcode = sprintf("%0".$nzeros."s",$barcode);
            $member->setBarcodeNmbr($barcode);
		  } else {
            $barcode = trim($mbr_row['barcode_nmbr']);
            $member->setBarcodeNmbr($barcode);
		  }
#		  print_r($mbr_row);
#          $member->setCreateDt($mbr_row['create_dt']);
#          $member->setLastChangeDt($mbr_row['last_change_dt']);
#          $member->setLastChangeUserid($mbr_row['last_change_userid']);
          $member->setLastChangeUserid($_SESSION["userid"]);
          $member->setUsername($mbr_row['username']);
          $member->setPwd($mbr_row['pwd']);
          $member->setPreName(iconv('tis-620','utf-8',$mbr_row['pre_name']));
          $member->setLastName(iconv('tis-620','utf-8',$mbr_row['last_name']));
          $member->setFirstName(iconv('tis-620','utf-8',$mbr_row['first_name']));
          $member->setDegree(iconv('tis-620','utf-8',$mbr_row['degree']));
          $member->setAddress(iconv('tis-620','utf-8',$mbr_row['address']));
          $member->setHomePhone($mbr_row['home_phone']);
#          $member->setWorkPhone($mbr_row['work_phone']);
          $member->setEmail($mbr_row['email']);
#          $member->setClassification($mbr_row['classification']);
          $member->setClassification($_POST['classification']);
          $member->setStatus('y');
#          $member->setLastActDate($mbr_row['last_activity_dt']);
          $validData = $member->validateData();
          if (!$validData) {
		    $error++;
          } else {
            $mbrQ = new MemberQuery();
            $mbrQ->connect();
            $dupBarcode = $mbrQ->DupBarcode($barcode);
            if (!$dupBarcode) {
              $mbrid = $mbrQ->insert($member);
              $mbrQ->updateActivity($mbrid);
              $mbrQ->close();
            }
		  }
        }
        echo $loc->getText("mbrImportCompleted");
      } else {
        echo $loc->getText("mbrCannotOpenFile");
      }
    } else {
      echo $loc->getText("mbrCannotUploadFile");
    }
  }
?>

<h1><?php echo $loc->getText("CSVImportHeader"); ?></h1>

<form method="post" enctype="multipart/form-data" action="<?php echo $_SERVER["SCRIPT_NAME"]; ?>">
  <div>
    <label for="upload"><?php echo $locCatalog->getText('CSVLabel', array('csv' => 'mbr_csv_template.csv')); ?></label>
  </div>
  <input type="file" name="upload" />

  <hr />
  <b><?php echo $locCatalog->getText('Defaults:'); ?></b>
  <table border=0>
    <tr>
      <td><?php echo $loc->getText("mbrFldsClassify"); ?></td>
      <td><?php printSelect("classification","mbr_classify_dm",$postVars); ?></td>
    </tr>
  </table>
  <input type="submit" name="submit" class="button" value="<?php echo $locCatalog->getText("UploadFile"); ?>" />
</form>
<?php
include("../shared/footer.php");
?>