<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  $tab = "circulation";
  $nav = "view";
  $restrictInDemo = true;
  require_once("../shared/logincheck.php");
  require_once("../classes/MemberQuery.php");
  require_once("../classes/Member.php");
  require_once("../functions/errorFuncs.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);
  
  $mbrid = 0 + $_GET["mbrid"];

  require_once("../classes/BiblioQuery.php");
  
  $mbrQ = new MemberQuery();
  $mbrQ->connect();
  if ($mbrQ->errorOccurred()) {
    $mbrQ->close();
    displayErrorPage($mbrQ);
  }
  
  if (!$mbr = $mbrQ->get($mbrid)) {
    $mbrQ->close();
    displayErrorPage($mbrQ);
  }
  
  // get image path
  $imgname = $mbr->getImageURL();
  $imgpath =  '../' . MEMBER_PATH . '/' . $imgname;
  
  if (file_exists($imgpath)) {
    chmod($imgpath, 666); // Windows platform compatibility, 666 is for "Nobody"
    unlink($imgpath); 
  }

  if (!mbrQ->deleteMemberImage($mbrid)) {
    $mbrQ->close();
    displayErrorPage($mbrQ);
  }
  
  $mbrQ->close();
  
  if ($_GET['redirect'] == 'edit') {
    header("Location: ../circ/mbr_edit_form.php?mbrid=" . U($mbrid)."&msg=".U($loc->gettext("This member's image has been removed.")));
  }
  else {
    header('Location: ../circ/mbr_view.php?mbrid=' . U($mbrid)."&msg=".U($loc->gettext("This member's image has been removed.")));
  }
  
