<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  $tab = "circulation";
  $nav = "pwd_reset";
  $restrictInDemo = true;
  require_once("../shared/logincheck.php");

  require_once("../classes/Member.php");
  require_once("../classes/MemberQuery.php");
  require_once("../functions/errorFuncs.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);
  
  #****************************************************************************
  #*  Checking for post vars.  Go back to form if none found.
  #****************************************************************************
  if (count($_POST) == 0) {
    header("Location: ../circ/mbr_pwd_form.php");
    exit();
  }

  #****************************************************************************
  #*  Validate data
  #****************************************************************************
  $mbr = new Member();
  $mbr->setMbrid($_POST["mbrid"]);
  $mbr->setPwd($_POST["pwd"]);
  $_POST["pwd"] = $mbr->getPwd();
  $mbr->setPwd2($_POST["pwd2"]);
  $_POST["pwd2"] = $mbr->getPwd2();
  $mbrid = $_POST["mbrid"];
  if (!$mbr->validatePwd()) {
    $pageErrors["pwd"] = $mbr->getPwdError();
    $_SESSION["postVars"] = $_POST;
    $_SESSION["pageErrors"] = $pageErrors;
    header("Location: ../circ/mbr_pwd_form.php?mbrid=".$mbrid);
    exit();
  }

  #**************************************************************************
  #*  Update member
  #**************************************************************************
  $mbrQ = new MemberQuery();
  $mbrQ->connect();
  if ($mbrQ->errorOccurred()) {
    $mbrQ->close();
    displayErrorPage($mbrQ);
  }
  if (!$mbrQ->resetPwd($mbr)) {
    $mbrQ->close();
    displayErrorPage($mbrQ);
  }
  $mbrQ->close();

  #**************************************************************************
  #*  Destroy form values and errors
  #**************************************************************************
  unset($_SESSION["postVars"]);
  unset($_SESSION["pageErrors"]);

  #**************************************************************************
  #*  Show success page
  #**************************************************************************
  require_once("../shared/header.php");
?>
<?php echo $loc->getText("mbrPwdResetPasswordReset"); ?><br><br>
<a href="../circ/mbr_view.php?mbrid=<?php echo $mbrid; ?>"><?php echo $loc->getText("mbrPwdResetReturn"); ?></a>

<?php require_once("../shared/footer.php"); ?>
