<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
require_once("../classes/Query.php");
require_once("../classes/Localize.php");

/******************************************************************************
 * AuthorityQuery data access component for authority
 *
 * @author David Stevens <dave@stevens.name>;
 * @version 1.0
 * @access public
 ******************************************************************************
 */
class AuthorityQuery extends Query {
  var $_itemsPerPage = 1;
  var $_rowNmbr = 0;
  var $_currentRowNmbr = 0;
  var $_currentPageNmbr = 0;
  var $_rowCount = 0;
  var $_pageCount = 0;
  var $_loc;

  function AuthorityQuery() {
    $this->Query();
    $this->_loc = new Localize(OBIB_LOCALE,"classes");
  }

  function setItemsPerPage($value) {
    $this->_itemsPerPage = $value;
  }
  function getCurrentRowNmbr() {
    return $this->_currentRowNmbr;
  }
  function getRowCount() {
    return $this->_rowCount;
  }
  function getPageCount() {
    return $this->_pageCount;
  }

  function _getCriteria($cols, &$words) {
    # Setting selection criteria SQL
    $prefix = " AND ";
    $criteria = "";
	$criteria .= $prefix . $this->_getLike($cols, $words);
    return $criteria;
  }
  
  function _getLike(&$cols,$word) {
    $prefix = "";
    $suffix = "";
    if (count($cols) > 1) {
      $prefix = "(";
      $suffix = ")";
    }
    $like = "";
    for ($i = 0; $i < count($cols); $i++) {
      $like .= $prefix;
      $like .= $this->mkSQL("%C LIKE %Q", $cols[$i], "%".$word."%");
      $prefix = " OR ";
    }
    $like .= $suffix;
    return $like ." ";
  }

  /****************************************************************************
   * Executes a query
   * @param string $type one of the global constants
   *               author,
   *               publisher,
   *               series,
   *               or topic
   * @param string @$words pointer to an array containing words to search for
   * @param integer $page What page should be returned if results are more than one page
   * @param string $sortBy column name to sort by.  Can be title or author
   * @return boolean returns false, if error occurs
   * @access public
   ****************************************************************************
   */
  function search($type, &$words, $page, $sortBy) {
    # Reset stats
    $this->_rowNmbr = 0;
    $this->_currentRowNmbr = 0;
    $this->_currentPageNmbr = $page;
    $this->_rowCount = 0;
    $this->_pageCount = 0;

    # Setting SQL join clause
    $join = "FROM biblio ";

    # Setting SQL where clause
    $criteria = "";

	switch ($type) {
	case 'author' :// author
		$sql = "SELECT author AS authority, count( * ) AS total ";
		$sqlcount = "SELECT COUNT(DISTINCT(author)) AS rowcount ";
		$join = "FROM biblio
						WHERE author IS NOT NULL ";
		$criteria = $this->_getCriteria(array("author"), $words);
		$groupby = "GROUP BY author ";
		break;
	case 'publisher' :// publisher
		$sql = "SELECT field_data AS authority, count( * ) AS total ";
		$sqlcount = "SELECT COUNT(DISTINCT(field_data)) AS rowcount ";
		$join = "FROM biblio_field
						WHERE tag = '260' AND subfield_cd = 'b' ";
		$criteria = $this->_getCriteria(array("field_data"), $words);
		$groupby = "GROUP BY field_data ";
		break;
	case 'series' :// series
		$sql = "SELECT field_data AS authority, count( * ) AS total ";
		$sqlcount = "SELECT COUNT(DISTINCT(field_data)) AS rowcount ";
		$join = "FROM biblio_field
						WHERE tag = '440' AND subfield_cd = 'a' ";
		$criteria = $this->_getCriteria(array("field_data"), $words);
		$groupby = "GROUP BY field_data ";
		break;
	case 'topic' :// topic
		$sql = "SELECT tmp.authority,sum(tmp.quantity) AS total ";
		$sqlcount = "SELECT COUNT(DISTINCT(tmp.authority)) AS rowcount ";
		$join = "FROM 
						(
						SELECT topic1 AS authority, count( * ) AS quantity
						FROM biblio
						WHERE topic1 IS NOT NULL AND topic1 != ''
						GROUP BY topic1
						UNION ALL
						SELECT topic2 , count( * )
						FROM biblio
						WHERE topic2 IS NOT NULL AND topic2 != ''
						GROUP BY topic2
						UNION ALL
						SELECT topic3 , count( * )
						FROM biblio
						WHERE topic3 IS NOT NULL AND topic3 != ''
						GROUP BY topic3
						UNION ALL
						SELECT topic4 , count( * )
						FROM biblio
						WHERE topic4 IS NOT NULL AND topic4 != ''
						GROUP BY topic4
						UNION ALL
						SELECT topic5 , count( * )
						FROM biblio
						WHERE topic5 IS NOT NULL AND topic5 != ''
						GROUP BY topic5
						) AS tmp 
						WHERE tmp.authority != '' ";
		$criteria = $this->_getCriteria(array("tmp.authority"), $words);
		$groupby = "GROUP BY tmp.authority ";
		break;
	}

    if ((sizeof($words) == 0) || ($words[0] == "" && !is_array($words))) {
    }
    else {
	}

    # Setting count query
    $sqlcount = $sqlcount.$join;
    $sqlcount = $sqlcount.$criteria;

    # Setting query that will return all the data
    $sql .= $join;
    $sql .= $criteria;
    $sql .= $groupby;
    $sql .= $this->mkSQL("ORDER BY %C ", $sortBy);

    # Setting limit so we can page through the results
    $offset = ($page - 1) * $this->_itemsPerPage;
    $limit = $this->_itemsPerPage;
    $sql .= $this->mkSQL("LIMIT %N, %N", $offset, $limit);

    # Running row count SQL statement
    if (!$this->_query($sqlcount, $this->_loc->getText("biblioSearchQueryErr1"))) {
      return false;
    }

    # Calculate stats based on row count
    $array = $this->_conn->fetchRow();
    $this->_rowCount = $array["rowcount"];
    $this->_pageCount = ceil($this->_rowCount / $this->_itemsPerPage);

    # Running search SQL statement
    return $this->_query($sql, $this->_loc->getText("biblioSearchQueryErr2"));
  }

  /****************************************************************************
   * Updates a bibliography in the biblio table.
    * @param string $type one of the global constants
   *               author,
   *               publisher,
   *               series,
   *               or topic
   * @param string @$words pointer to an array containing words to search for
   * @return boolean returns false, if error occurs
   * @access public
   ****************************************************************************
   */
  /*###########################
    # WORKS WITH NEW FORMAT   #
    ###########################*/
  function update($type,$new,$old) {

    // updating authority table
	switch ($type) {
	case 'author' :// author
		$sql = $this->mkSQL("UPDATE biblio
						SET author = %Q
						WHERE author = %Q ", $new, $old);
		break;
	case 'publisher' :// publisher
		$sql = $this->mkSQL("UPDATE biblio_field
						SET field_data = %Q
						WHERE tag = '260' AND subfield_cd = 'b' AND field_data = %Q ", $new, $old);
		break;
	case 'series' :// series
		$sql = $this->mkSQL("UPDATE biblio_field
						SET field_data = %Q
						WHERE tag = '440' AND subfield_cd = 'a' AND field_data = %Q ", $new, $old);
		break;
	case 'topic' :// topic
		$sql = $this->mkSQL("UPDATE biblio
						SET topic1 = %Q
						WHERE topic1 != '' AND topic1 = %Q ", $new, $old);
		if (!$this->_query($sql, $this->_loc->getText("biblioQueryUpdateErr1"))) {
		  return false;
		}
		$sql = $this->mkSQL("UPDATE biblio
						SET topic2 = %Q
						WHERE topic2 != '' AND topic2 = %Q ", $new, $old);
		if (!$this->_query($sql, $this->_loc->getText("biblioQueryUpdateErr1"))) {
		  return false;
		}
		$sql = $this->mkSQL("UPDATE biblio
						SET topic3 = %Q
						WHERE topic3 != '' AND topic3 = %Q ", $new, $old);
		if (!$this->_query($sql, $this->_loc->getText("biblioQueryUpdateErr1"))) {
		  return false;
		}
		$sql = $this->mkSQL("UPDATE biblio
						SET topic4 = %Q
						WHERE topic4 != '' AND topic4 = %Q ", $new, $old);
		if (!$this->_query($sql, $this->_loc->getText("biblioQueryUpdateErr1"))) {
		  return false;
		}
		$sql = $this->mkSQL("UPDATE biblio
						SET topic5 = %Q
						WHERE topic5 != '' AND topic5 = %Q ", $new, $old);
		break;
	}

    if (!$this->_query($sql, $this->_loc->getText("biblioQueryUpdateErr1"))) {
      return false;
    }

    return true;
  }
}

?>
