<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../functions/formatFuncs.php");

/******************************************************************************
 * Member represents a library member.  Contains business rules for
 * member data validation.
 *
 * @author David Stevens <dave@stevens.name>;
 * @version 1.0
 * @access public
 ******************************************************************************
 */
class Member {
  var $_mbrid = 0;
  var $_barcodeNmbr = 0;
  var $_barcodeNmbrError = "";
  var $_createDt = "";
  var $_lastChangeDt = "";
  var $_lastChangeUserid = "";
  var $_lastChangeUsername = "";
  var $_pwd = "";
  var $_pwdError = "";
  var $_pwd2 = "";
  var $_username = "";
  var $_usernameError = "";
  var $_classification = "";
  var $_preName = "";
  var $_lastName = "";
  var $_lastNameError = "";
  var $_firstName = "";
  var $_firstNameError = "";
  var $_degree = "";
  var $_email = "";
  var $_address = "";
  var $_homePhone = "";
  var $_workPhone = "";
  var $_status = "y";
  var $_statusError = "";
  var $_custom = array();
  var $_lastActivityDate = "0000-00-00 00:00:00";
  var $_imageURL = "";
  var $_imageURLError = "";
  

  /****************************************************************************
   * @return boolean true if data is valid, otherwise false.
   * @access public
   ****************************************************************************
   */
  function validateData() {
    global $loc;
    
    $valid = true;
    if ($this->_barcodeNmbr == "") {
      $valid = false;
      $this->_barcodeNmbrError = $loc->getText("Card number is required.");
    } else if (!ctypeAlnum($this->_barcodeNmbr)) {
      $valid = false;
      $this->_barcodeNmbrError = $loc->getText("Card number must be all alphabetic and numeric characters.");
    }
    if ($this->_lastName == "") {
      $valid = false;
      $this->_lastNameError = $loc->getText("Last name is required.");
    }
    if ($this->_firstName == "") {
      $valid = false;
      $this->_firstNameError = $loc->getText("First name is required.");
    }
    if (strcmp($this->_status, "y") != 0 && strcmp($this->_status, "n") != 0) {
      $valid = false;
      $this->_statusError = $loc->getText("Status options is incorrect.");
    }

    return $valid;
  }
  
  /****************************************************************************
   * @return boolean true if data is valid, otherwise false.
   * @access public
   ****************************************************************************
   */
  function validatePwd() {
    global $loc;
	
    $valid = true;
    if (strlen($this->_pwd) < 4) {
      $valid = false;
      $this->_pwdError = $loc->getText("Password must be at least 4 characters.");
    } elseif (substr_count($this->_pwd, " ") > 0) {
      $valid = false;
      $this->_pwdError = $loc->getText("Password must not contain any spaces.");
    } elseif ($this->_pwd != $this->_pwd2) {
      $valid = false;
      $this->_pwdError = $loc->getText("Passwords do not match.");
    }
    return $valid;
  }

  function getCustom($field) {
    if (isset($this->_custom[$field])) {
      return $this->_custom[$field];
    }
    return "";
  }
  function setCustom($field, $value) {
    $this->_custom[$field] = $value;
  }

  /****************************************************************************
   * Getter methods for all fields
   * @return string
   * @access public
   ****************************************************************************
   */
  function getMbrid() {
    return $this->_mbrid;
  }
  function getBarcodeNmbr() {
    return $this->_barcodeNmbr;
  }
  function getBarcodeNmbrError() {
    return $this->_barcodeNmbrError;
  }
  function getCreateDt() {
    $thdate = '';
    $thdate = explode('-', date('d-m-Y', strtotime($this->_createDt)));
    return $thdate[0].'-'.$thdate[1].'-'.($thdate[2]+543);
#    return $this->_createDt;
  }
  function getLastChangeDt() {
    return $this->_lastChangeDt;
  }
  function getLastChangeUserid() {
    return $this->_lastChangeUserid;
  }
  function getLastChangeUsername() {
    return $this->_lastChangeUsername;
  }
  function getLastName() {
    return $this->_lastName;
  }
  function getLastNameError() {
    return $this->_lastNameError;
  }
  function getFirstName() {
    return $this->_firstName;
  }
  function getFirstNameError() {
    return $this->_firstNameError;
  }
  function getFirstLastName() {
    return $this->_preName." ".$this->_firstName." ".$this->_lastName;
  }
  function getLastFirstName() {
    return $this->_lastName.", ".$this->_firstName;
  }
  function getAddress() {
    return $this->_address;
  }
  function getHomePhone() {
    return $this->_homePhone;
  }
  function getWorkPhone() {
    return $this->_workPhone;
  }
  function getEmail() {
    return $this->_email;
  }
  function getClassification() {
    return $this->_classification;
  }
  function getStatus() {
    return $this->_status;
  }
  function getStatusError() {
    return $this->_statusError;
  }
  function getLastActDate() {
    return $this->_lastActivityDate;
  }
  function getPreName() {
    return $this->_preName;
  }
  function getDegree() {
    return $this->_degree;
  }
  function getUsername() {
    return $this->_username;
  }
  function getUsernameError() {
    return $this->_usernameError;
  }
  function getPwd() {
    return $this->_pwd;
  }
  function getPwd2() {
    return $this->_pwd2;
  }
  function getPwdError() {
    return $this->_pwdError;
  }
  function getImageURL() {
	return $this->_imageURL;
  }

  /****************************************************************************
   * Setter methods for all fields
   * @param string $value new value to set
   * @return void
   * @access public
   ****************************************************************************
   */
  function setMbrid($value) {
    $this->_mbrid = trim($value);
  }
  function setBarcodeNmbr($value) {
    $this->_barcodeNmbr = trim($value);
  }
  function setCreateDt($value) {
    $this->_createDt = trim($value);
  }
  function setLastChangeDt($value) {
    $this->_lastChangeDt = trim($value);
  }
  function setLastChangeUserid($value) {
    $this->_lastChangeUserid = trim($value);
  }
  function setLastChangeUsername($value) {
    $this->_lastChangeUsername = trim($value);
  }
  function setLastName($value) {
    $this->_lastName = trim($value);
  }
  function setLastNameError($value) {
    $this->_lastNameError = trim($value);
  }
  function setFirstName($value) {
    $this->_firstName = trim($value);
  }
  function setFirstNameError($value) {
    $this->_firstNameError = trim($value);
  }
  function setAddress($value) {
    $this->_address = trim($value);
  }
  function setHomePhone($value) {
    $this->_homePhone = trim($value);
  }
  function setWorkPhone($value) {
    $this->_workPhone = trim($value);
  }
  function setEmail($value) {
    $this->_email = trim($value);
  }
  function setClassification($value) {
    $this->_classification = trim($value);
  }
  function setStatus($value) {
    $this->_status = trim($value);
  }
  function setStatusError($value) {
    $this->_statusError = trim($value);
  }
  function setLastActDate($value) {
    $this->_lastActivityDate = date('Y-m-d H:i:s', strtotime($value));
  }
  function setPreName($value) {
    $this->_preName = trim($value);
  }
  function setDegree($value) {
    $this->_degree = trim($value);
  }
  function setUsername($username) {
    $this->_username = strtolower(trim($username));
  }
  function setPwd($pwd) {
    $this->_pwd = strtolower(trim($pwd));
  }
  function setPwd2($pwd) {
    $this->_pwd2 = strtolower(trim($pwd));
  }
  function setImageURL($value) {
    $this->_imageURL = trim($value);
  }
  
  function attachImage() {
    global $loc;

    if (!empty($_FILES['image']["tmp_name"]) && ($this->_imageURL == "")) {
      if ($info = getimagesize($_FILES['image']["tmp_name"])) {
        $filename = $_FILES['image']["name"];
        $filename_parts = explode(".", $filename);
        unset($filename_parts[count($filename_parts) - 1]);
        $filename = implode("-", $filename_parts);
		$filename = $this->_barcodeNmbr;
        $allow_types = array(
          'image/jpeg',
          'image/png',
          'image/gif',
        );
        // If file type is allowed
        if (in_array($info["mime"], $allow_types)) {
          // Create directory when necessary, raise error when failed to create "not exist" one.
          if (!(is_dir('../' . MEMBER_PATH) || is_dir('../' . MEMBER_PATH_TMP))) {
            $dir_error = FALSE;
            if (is_dir('../' . dirname(MEMBER_PATH))) {
              // Create new one.
              $MEMBER_PATH = @mkdir('../' . MEMBER_PATH, 0777);
              $tmp_path = @mkdir('../' . MEMBER_PATH_TMP, 0777);
              
              if (!$MEMBER_PATH) {
                if (is_dir('../' . MEMBER_PATH)) {
                  if (decoct(fileperms('../' . MEMBER_PATH)) != 0777) {
                    $force_chmod = @chmod('../' . MEMBER_PATH, 0777);
                    if (!$force_chmod) {
                      $dir_error = TRUE;
                    }
                  }
                }
                else {
                  $dir_error = TRUE;
                }
              }
              
              if (!$tmp_path) {
                if (is_dir('../' . MEMBER_PATH_TMP)) {
                  if (decoct(fileperms('../' . MEMBER_PATH_TMP)) != 0777) {
                    $force_chmod = @chmod('../' . MEMBER_PATH_TMP, 0777);
                    if (!$force_chmod) {
                      $dir_error = TRUE;
                    }
                  }
                }
                else {
                  $dir_error = TRUE;
                }
              }
              
              if ($dir_error) {
                print_r('<span style="color: red"><strong>Error:</strong> Failed to save book cover! please set chmod 777 to /media directory.</span><br />');
                return false;
              }
            }
          }
          $ext = image_type_to_extension($info[2]);
          $tmp = md5($filename.session_id().time());
          $filename = $filename."_".substr($tmp, strlen($tmp) - 7, strlen($tmp)).$ext;
          $filepath = "../" . MEMBER_PATH . "/$filename";
          copy($_FILES['image']["tmp_name"], $filepath);
          $thumb_filename = make_thumbnail($filepath, array('width' => 90));
          copy($thumb_filename, $filepath);
          unlink($thumb_filename);
          $this->setImageURL($filename);
        }
        else {
          $valid = false;
          $this->_imageURLError = $loc->getText("biblioFieldErrorPictureType");
        }
      }
      else {
        $valid = false;
        $this->_imageURLError = $loc->getText("biblioFieldErrorPictureLoadFailed");
      }
    } else {
        $valid = false;
        $this->_imageURLError = $loc->getText("biblioFieldErrorPictureExistedPleaseRemove");
	}

    return $valid;
  }
  
}

?>
