<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
require_once("../shared/global_constants.php");
require_once("../classes/Query.php");

/******************************************************************************
 * MemberQuery data access component for library members
 *
 * @author David Stevens <dave@stevens.name>;
 * @version 1.0
 * @access public
 ******************************************************************************
 */
class MemberQuery extends Query {
  /****************************************************************************
   * Executes a query
   * @param string $mbrid (optional) mbrid of member to select
   * @return boolean returns false, if error occurs
   * @access public
   ****************************************************************************
   */
  function execSelect($mbrid="") {
    $sql = "select * from member";
    if ($mbrid != "") {
      $sql .= $this->mkSQL(" where mbrid=%N ", $mbrid);
    }
    $sql .= " order by last_name, first_name";
    return $this->_query($sql, "Error accessing member information.");
  }
  /****************************************************************************
   * Executes a query to verify a signon username and password
   * @param string $username username of member to select
   * @param string $pwd password of member to select
   * @return boolean returns false, if error occurs
   * @access public
   ****************************************************************************
   */
  function verifySignon($username, $pwd) {
    $sql = $this->mkSQL("select * from member "
                        . "where username = lower(%Q) "
                        . " and pwd = md5(lower(%Q)) ",
                        $username, $pwd);
    return $this->_query($sql, "Error verifying username and password.");
  }

  /****************************************************************************
   * Fetches a row from the query result and populates the Member object.
   * @return Member returns member or false if no more members to fetch
   * @access public
   ****************************************************************************
   */
  function fetchMember() {
    $array = $this->_conn->fetchRow();
    if ($array == false) {
      return false;
    }
    $member = new Member();
    $member->setMbrid($array["mbrid"]);
    $member->setLastName($array["last_name"]);
    $member->setFirstName($array["first_name"]);
    return $member;
  }

  /****************************************************************************
   * Returns true if username already exists
   * @param string $username member username
   * @param string $mbrid member mbrid
   * @return boolean returns true if username already exists
   * @access private
   ****************************************************************************
   */
  function _dupUserName($username, $mbrid=0) {
    $sql = $this->mkSQL("select count(*) from member where username = %Q "
                        . " and mbrid <> %N", $username, $mbrid);
    if (!$this->_query($sql, "Error checking for dup username.")) {
      return false;
    }
    $array = $this->_conn->fetchRow(OBIB_NUM);
    if ($array[0] > 0) {
      return true;
    }
    return false;
  }

}

?>
