<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Common translation text shared among multiple pages
#****************************************************************************
$trans["circCancel"]              = "\$text = 'ยกเลิก';";
$trans["circDelete"]              = "\$text = 'ลบ';";
$trans["circSuspend"]             = "\$text = 'ระงับ';";
$trans["circPermanentlyDelete"]   = "\$text = 'ลบ';";
$trans["circLogout"]              = "\$text = 'ออกจากระบบ';";
$trans["circAdd"]                 = "\$text = 'บันทึก';";
$trans["mbrDupBarcode"]           = "\$text = 'เลขทะเบียนหนังสือ (บาร์โค้ด) %barcode% ถูกใช้ไปแล้ว';";

#****************************************************************************
#*  Translation text for page index.php
#****************************************************************************
$trans["indexHeading"]            = "\$text='งานบริการยืม-คืน';";
$trans["indexCardHdr"]            = "\$text='การยืมโดยค้นหาจากหมายเลขสมาชิก (บาร์โค้ด):';";
$trans["indexCard"]               = "\$text='หมายเลขสมาชิก (บาร์โค้ด):';";
$trans["indexSearch"]             = "\$text='ค้นหา';";
$trans["indexNameHdr"]            = "\$text='การยืมโดยค้นหาจากชื่อสมาชิก:';";
$trans["indexName"]               = "\$text='ชื่อสมาชิก:';";

#****************************************************************************
#*  Translation text for page noauth.php
#****************************************************************************
$trans["noauthMsg"]                = "\$text = 'คุณไม่มีสิทธิ์สำหรับการใช้งานในส่วนนี้';";

#****************************************************************************
#*  Translation text for page mbr_new_form.php, mbr_edit_form.php and mbr_fields.php
#****************************************************************************
$trans["Mailing Address:"]        = "\$text='ที่อยู่:';";
$trans["mbrNewForm"]              = "\$text='เพิ่มสมาชิกใหม่';";
$trans["mbrEditForm"]             = "\$text='แก้ไข';";
$trans["mbrFldsHeader"]           = "\$text=':';";
$trans["mbrFldsCardNmbr"]         = "\$text='หมายเลขสมาชิก (บาร์โค้ด):';";
$trans["mbrFldsMbrName"]         = "\$text='รหัสผู้ใช้:';";
$trans["mbrFldsMbrPassword"]         = "\$text='รหัสผ่าน:';";
$trans["mbrFldsPreName"]         = "\$text='คำนำหน้าชื่อ:';";
$trans["mbrFldsLastName"]         = "\$text='นามสกุล:';";
$trans["mbrFldsFirstName"]        = "\$text='ชื่อ:';";
$trans["mbrFldsDegree"]        = "\$text='ระดับชั้น/ตำแหน่ง:';";
$trans["mbrFldsAddr1"]            = "\$text='ที่อยู่ 1:';";
$trans["mbrFldsAddr2"]            = "\$text='ที่อยู่ 2:';";
$trans["mbrFldsCity"]             = "\$text='จังหวัด:';";
$trans["mbrFldsStateZip"]         = "\$text='รหัสไปรษณีย์:';";
$trans["mbrFldsHomePhone"]        = "\$text='เบอร์โทรศัพท์:';";
$trans["mbrFldsWorkPhone"]        = "\$text='เบอร์โทรศัพท์ที่ทำงาน:';";
$trans["mbrFldsEmail"]            = "\$text='อีเมล:';";
$trans["mbrFldsClassify"]         = "\$text='ประเภทสมาชิก:';";
$trans["mbrFldsStatus"]           = "\$text='สถานะ:';";
$trans["mbrFldsPic"]           = "\$text='รูปสมาชิก:';";
$trans["mbrFldsGrade"]            = "\$text='หน่วยงานที่ทำงาน:';";
$trans["mbrFldsTeacher"]          = "\$text='สถาบันที่ศึกษา:';";
$trans["mbrFldsSubmit"]           = "\$text='บันทึก';";
$trans["mbrFldsCancel"]           = "\$text='ยกเลิก';";
$trans["mbrsearchResult"]         = "\$text='หน้าแสดงผล: ';";
$trans["mbrsearchprev"]           = "\$text='ก่อนหน้านี้';";
$trans["mbrsearchnext"]           = "\$text='หน้าถัดไป';";
$trans["mbrsearchNoResults"]      = "\$text='ไม่พบผลการค้น';";
$trans["mbrsearchFoundResults"]   = "\$text=' รายการที่ค้นพบ';";
$trans["mbrsearchSearchResults"]  = "\$text='ผลการสืบค้น:';";
$trans["mbrsearchCardNumber"]     = "\$text='หมายเลขสมาชิก (บาร์โค้ด):';";
$trans["mbrsearchClassification"] = "\$text='ประเภท:';";
$trans["mbrsearchStatus"]         = "\$text='สถานะ:';";
$trans["mbrActive"]               = "\$text='ปกติ';";
$trans["mbrInactive"]             = "\$text='ระงับ';";
$trans["mbrAutoBarcode"]          = "\$text='ใช้หมายเลขสมาชิก (บาร์โค้ด) อัตโนมัติ';";
$trans["mbrLatestBarcode"]        = "\$text='หมายเลขสมาชิก (บาร์โค้ด) ล่าสุด';";
$trans["mbrViewLastActDate"]   = "\$text='ใช้งานล่าสุดเมื่อ:';";
$trans["mbrFormattedDate"]      = <<<INNERHTML

\$this_date = explode('-', date('D-d-m-Y-H:i:s', strtotime('%date%')));
\$thDay = array(
  'Sun' => 'อาทิตย์',
  'Mon' => 'จันทร์',
  'Tue' => 'อังคาร',
  'Wed' => 'พุธ',
  'Thu' => 'พฤหัส',
  'Fri' => 'ศุกร์',
  'Sat' => 'เสาร์',
);
\$thMonth = array(
  1 => 'ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.', 'พ.ค.', 'มิ.ย.',
  'ก.ค.', 'ส.ค.', 'ก.ย.', 'ต.ค.', 'พ.ย.', 'ธ.ค.');
\$thMonthLong = array(
  1 => 'มกราคม', 'กุมภาพันธ์', 'มีนาคม', 'เมษายน',
  'พฤษภาคม', 'มิถุนายน', 'กรกฎาคม', 'สิงหาคม',
  'กันยายน', 'ตุลาคม', 'พฤศจิกายน', 'ธันวาคม');
  

  
\$text= \$this_date[1] . '-' . \$this_date[2] . '-' . (543 + \$this_date[3]) . ' ' . \$this_date[4];

INNERHTML;

#****************************************************************************
#*  Translation text for page mbr_new.php
#****************************************************************************
$trans["mbrNewSuccess"]           = "\$text='เพิ่มสมาชิกเรียบร้อยแล้ว';";

#****************************************************************************
#*  Translation text for page mbr_edit.php
#****************************************************************************
$trans["mbrEditSuccess"]          = "\$text='แก้ไขสมาชิกเรียบร้อยแล้ว';";

#****************************************************************************
#*  Translation text for page mbr_view.php
#****************************************************************************
$trans["mbrViewHead1"]            = "\$text='ข้อมูลสมาชิก:';";
$trans["mbrViewName"]             = "\$text='ชื่อ:';";
$trans["mbrViewDegree"]        = "\$text='ระดับชั้น/ตำแหน่ง:';";
$trans["mbrViewAddr"]             = "\$text='ที่อยู่:';";
$trans["mbrViewCardNmbr"]         = "\$text='หมายเลขสมาชิก (บาร์โค้ด):';";
$trans["mbrViewClassify"]         = "\$text='ประเภทสมาชิก:';";
$trans["mbrViewPhone"]            = "\$text='เบอร์โทร:';";
$trans["mbrViewPhoneHome"]        = "\$text='บ้าน:';";
$trans["mbrViewPhoneWork"]        = "\$text='ทำงาน:';";
$trans["mbrViewEmail"]            = "\$text='อีเมล:';";
$trans["mbrViewGrade"]            = "\$text='School Grade:';";
$trans["mbrViewTeacher"]          = "\$text='Teacher:';";
$trans["mbrViewHead2"]            = "\$text='ข้อมูลการยืม:';";
$trans["mbrViewStatColHdr1"]      = "\$text='ประเภททรัพยากร';";
$trans["mbrViewStatColHdr2"]      = "\$text='สถานะ';";
$trans["mbrViewStatColHdr3"]      = "\$text='กำหนดสิทธิ์การยืม';";
$trans["mbrViewStatColHdr4"]      = "\$text='จำนวนเล่ม';";
$trans["mbrViewStatColHdr5"]      = "\$text='การยืมต่อ';";
$trans["mbrViewHead3"]            = "\$text='ใส่เลขทะเบียนหนังสือ (บาร์โค้ด) ที่ต้องการยืม:';";
$trans["mbrViewBarcode"]          = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด):';";
$trans["mbrViewCheckOut"]         = "\$text='ยืม';";
$trans["mbrViewOverrideDueDate"]         = "\$text='ใส่วันกำหนดคืนเอง';";
$trans["mbrViewDueDate"]         = "\$text='กำหนดคืน:';";
$trans["mbrViewHead4"]            = "\$text='ข้อมูลทรัพยากรห้องสมุดที่ยืม:';";
$trans["mbrViewOutHdr1"]          = "\$text='วันที่ยืม';";
$trans["mbrViewOutHdr2"]          = "\$text='ประเภททรัพยากร';";
$trans["mbrViewOutHdr3"]          = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["mbrViewOutHdr4"]          = "\$text='ชื่อเรื่อง';";
$trans["mbrViewOutHdr5"]          = "\$text='ผู้แต่ง';";
$trans["mbrViewOutHdr6"]          = "\$text='กำหนดคืน';";
$trans["mbrViewOutHdr7"]          = "\$text='เกินกำหนด';";
$trans["mbrViewOutHdr8"]          = "\$text='ยืมต่อ';";
$trans["mbrViewOutHdr9"]          = "\$text='ครั้ง';";
$trans["mbrViewNoCheckouts"]      = "\$text='ไม่มีรายการทรัพยากรห้องสมุดถูกยืมออก';";
$trans["mbrViewHead5"]            = "\$text='การจอง:';";
$trans["mbrViewHead6"]            = "\$text='ข้อมูลทรัพยากรห้องสมุดที่จอง:';";
$trans["mbrViewPlaceHold"]        = "\$text='จอง';";
$trans["mbrViewHoldHdr1"]         = "\$text='ยกเลิก';";
$trans["mbrViewHoldHdr2"]         = "\$text='วันที่จอง';";
$trans["mbrViewHoldHdr3"]         = "\$text='ประเภททรัพยากร';";
$trans["mbrViewHoldHdr4"]         = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["mbrViewHoldHdr5"]         = "\$text='ชื่อเรื่อง';";
$trans["mbrViewHoldHdr6"]         = "\$text='ผู้แต่ง';";
$trans["mbrViewHoldHdr7"]         = "\$text='สถานภาพ';";
$trans["mbrViewHoldHdr8"]         = "\$text='วันที่คืน';";
$trans["mbrViewNoHolds"]          = "\$text='ไม่มีรายการทรัพยากรห้องสมุดที่ถูกจอง';";
$trans["mbrViewBalMsg"]           = "\$text='หมายเหตุ: คุณยังมีค่าปรับยืมหนังสือเกินค้างอยู่จำนวน %bal%';";
$trans["mbrViewBalMsg2"]          = "\$text = 'หมายเหตุ: หนังสือเล่มนี้มีค่าปรับที่ต้องชำระจำนวน %fee%';";
$trans["mbrPrintCheckouts"]       = "\$text='พิมพ์ข้อมูลการยืม';";
$trans["mbrViewRenew"]              = "\$text='ต่ออายุ';";
$trans["mbrViewDel"]              = "\$text='ลบ';";
$trans["mbrViewStatus"]           = "\$text='สถานะ:';";
$trans["Are you sure to remove this picture?"]  = "\$text = 'ยืนยันการลบภาพนี้ใช่หรือไม่?';";
$trans["mbrPicRemove"]  = "\$text = 'ลบภาพออก';";


#****************************************************************************
#*  Translation text for page checkout.php
#****************************************************************************
$trans["checkoutBalErr"]          = "\$text='ต้องจ่ายค่าปรับเกินกำหนดก่อนจึงสามารถยืมออกได้';";
$trans["checkoutErr1"]            = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด) ต้องเป็นตัวเลขหรือตัวอักษรเท่านั้น';";
$trans["checkoutErr2"]            = "\$text='ไม่พบเลขทะเบียนหนังสือ (บาร์โค้ด) ต้องการยืมออก';";
$trans["checkoutErr3"]            = "\$text=' %barcode% ถูกยืมออกอยู่ในขณะนี้';";
$trans["checkoutErr4"]            = "\$text=' %barcode% ไม่สามารถยืมได้';";
$trans["checkoutErr5"]            = "\$text=' %barcode% ปัจจุบันถูกจองสำหรับยืมตัวโดยสมาชิกคนอื่น';";
$trans["checkoutErr6"]            = "\$text='สมาชิกถูกจำกัดการยืมจากประเภททรัพยากรห้องสมุดพิเศษ';";
$trans["checkoutErr7"]            = "\$text=' %barcode% ถูกจำกัดสิทธิ์การยืมต่อ';";
$trans["checkoutErr8"]            = "\$text=' %barcode% ยืมเกินกำหนดไม่สามารถยืมต่อได้';";
$trans["checkoutErr9"]            = "\$text='สมาชิกถูกระงับการใช้งาน ไม่สามารถทำรายการได้';";

#****************************************************************************
#*  Translation text for page mbr_pwd_reset_form.php
#****************************************************************************
$trans["mbrPwdResetHead"]          	= "\$text = 'เปลี่ยนรหัสผ่านสมาชิก:';";
$trans["mbrPwdResetPassword"]          = "\$text = 'ใส่รหัสผ่าน';";
$trans["mbrPwdResetReenterpassword"]   = "\$text = 'ยืนยันรหัสผ่าน';";

#****************************************************************************
#*  Translation text for page mbr_pwd_reset.php
#****************************************************************************
$trans["mbrPwdResetPasswordReset"]          	= "\$text = 'เปลี่ยนรหัสผ่านเรียบร้อยแล้ว';";
$trans["mbrPwdResetReturn"]     = "\$text = 'กลับไปข้อมูลสมาชิก';";

#****************************************************************************
#*  Translation text for page shelving_cart.php
#****************************************************************************
$trans["shelvingCartErr1"]        = "\$text='ให้ระบุเป็นตัวเลขหรือตัวอักษร';";
$trans["shelvingCartErr2"]        = "\$text='ไม่พบเลขทะเบียนหนังสือ (บาร์โค้ด) นี้';";
$trans["shelvingCartErr3"]        = "\$text='ตัวเล่มฉบับนี้ยังไม่ถูกยืมออกไป';";
$trans["shelvingCartTrans"]       = "\$text='ค่าปรับล่าสุด (barcode=%barcode%)';";

#****************************************************************************
#*  Translation text for page checkin_form.php
#****************************************************************************
$trans["checkinFormHdr1"]         = "\$text='การคืนทรัพยากรห้องสมุด:';";
$trans["checkinFormBarcode"]      = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด):';";
$trans["checkinFormShelveButton"] = "\$text='คืน';";
$trans["checkinFormCheckinLink1"] = "\$text='คืนเฉพาะรายการที่เลือก';";
$trans["checkinFormCheckinLink2"] = "\$text='คืนรายการทั้งหมด';";
$trans["checkinFormHdr2"]         = "\$text='ยืนยันการคืน:';";
$trans["checkinFormColHdr1"]      = "\$text='คืนเวลา';";
$trans["checkinFormColHdr2"]      = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["checkinFormColHdr3"]      = "\$text='ชื่อเรื่อง';";
$trans["checkinFormColHdr4"]      = "\$text='ผู้แต่ง';";
$trans["checkinFormEmptyCart"]    = "\$text='ทรัพยากรห้องสมุดอยู่บนชั้น';";
$trans["checkinDone1"]                  = "\$text='สมาชิก %fname% %lname% คืนบาร์โค้ด %barcode% เรียบร้อยแล้ว';";
$trans["checkinDone2"]                  = "\$text='คืนบาร์โค้ด %barcode% เรียบร้อยแล้ว';";

#****************************************************************************
#*  Translation text for page checkin.php
#****************************************************************************
$trans["checkinErr1"]             = "\$text='ไม่มีเลขทะเบียนหนังสือ (บาร์โค้ด) ให้เลือกคืน';";

#****************************************************************************
#*  Translation text for page hold_message.php
#****************************************************************************
$trans["holdMessageHdr"]          = "\$text='ตัวเล่มฉบับนี้ถูกจองไว้!';";
$trans["holdMessageMsg1"]         = "\$text='ตัวเล่มที่มีเลขทะเบียนหนังสือ (บาร์โค้ด) รหัส %barcode% ที่กำลังทำรายการคืน มีสมาชิกจองเอาไว้ โปรดเรียกดูข้อมูลการจองได้จากเมนู <b>งานสถิติและรายงาน -> รายงานการยืม-คืน -> การจองทรัพยากร</b><br />สถานะของตัวเล่มฉบับนี้ถูกเปลี่ยนเป็น \"ถูกจอง\"';";
$trans["holdMessageMsg2"]         = "\$text='กลับไปรายการคืนทรัพยากรห้องสมุด';";

#****************************************************************************
#*  Translation text for page place_hold.php
#****************************************************************************
$trans["placeHoldErr1"]           = "\$text='ต้องใส่ตัวเลขเท่านั้น';";
$trans["placeHoldErr2"]           = "\$text='ยังไม่สามารจองสำหรับยืมต่อได้';";
$trans["placeHoldErr3"]           = "\$text='สมาชิกนี้ยืมออกอยู่ขณะนี้ไม่สามารถจองต่อได้';";
$trans["placeHoldErrNotChkOut"]       = "\$text='รายการนี้ยังไม่ถูกยืมออกไป';";
$trans["placeHoldErrDup"]       = "\$text='สมาชิกคนนี้ได้แจ้งขอจองตัวเล่มฉบับนี้ไว้ก่อนแล้ว';";

#****************************************************************************
#*  Translation text for page mbr_del_confirm.php
#****************************************************************************
$trans["mbrDelConfirmWarn"]       = "\$text = 'สมาชิก %name%  มีทรัพยากรห้องสมุดคงค้าง %checkoutCount% รายการและรายการจอง %holdCount% รายการ  ถ้าต้องการลบสมาชิกคนนี้ ต้องไม่มีทรัพยากรห้องสมุดและรายการจองค้างอยู่';";
$trans["mbrDelConfirmReturn"]     = "\$text = 'กลับไปข้อมูลสมาชิก';";
$trans["mbrDelConfirmMsg"]        = "\$text = 'ยืนยันการลบสมาชิกชื่อ %name% ';";

#****************************************************************************
#*  Translation text for page mbr_del.php
#****************************************************************************
$trans["mbrDelSuccess"]           = "\$text='สมาชิกชื่อ %name% ถูกลบ';";
$trans["mbrSuspendSuccess"]       = "\$text='สมาชิกชื่อ %name% ถูกระงับ';";
$trans["mbrDelReturn"]            = "\$text='กลับไปรายการค้นหาสมาชิก';";

#****************************************************************************
#*  Translation text for page mbr_history.php
#****************************************************************************
$trans["mbrHistoryHead1"]         = "\$text='ข้อมูลการยืม:';";
$trans["mbrHistoryNoHist"]        = "\$text='ไม่พบข้อมูลการยืม';";
$trans["mbrHistoryHdr1"]          = "\$text='เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["mbrHistoryHdr2"]          = "\$text='ชื่อเรื่อง';";
$trans["mbrHistoryHdr3"]          = "\$text='ผู้แต่ง';";
$trans["mbrHistoryHdr4"]          = "\$text='สถานะ';";
$trans["mbrHistoryHdr5"]          = "\$text='วันที่ยืม';";
$trans["mbrHistoryHdr6"]          = "\$text='กำหนดคืน';";

#****************************************************************************
#*  Translation text for page mbr_account.php
#****************************************************************************
$trans["mbrAccountLabel"]         = "\$text='เปลี่ยนแปลงข้อมูลค่าปรับ:';";
$trans["mbrAccountTransTyp"]      = "\$text='เลือกรายการ:';";
$trans["mbrAccountAmount"]        = "\$text='จำนวน:';";
$trans["mbrAccountDesc"]          = "\$text='รายละเอียด:';";
$trans["mbrAccountHead1"]         = "\$text='ข้อมูลค่าปรับ:';";
$trans["mbrAccountNoTrans"]       = "\$text='ไม่พบรายการ';";
$trans["mbrAccountOpenBal"]       = "\$text='รายงานทั้งหมด';";
$trans["mbrAccountDel"]           = "\$text='ลบ';";
$trans["mbrAccountHdr1"]          = "\$text='ยกเลิก';";
$trans["mbrAccountHdr2"]          = "\$text='วันที่';";
$trans["mbrAccountHdr3"]          = "\$text='ประเภท';";
$trans["mbrAccountHdr4"]          = "\$text='รายละเอียด';";
$trans["mbrAccountHdr5"]          = "\$text='จำนวนเงิน';";
$trans["mbrAccountHdr6"]          = "\$text='รวมจำนวนเงิน';";
$trans["mbrAccountLink"]           = "\$text='ดูข้อมูลค่าปรับของสมาชิกท่านนี้';";

#****************************************************************************
#*  Translation text for page mbr_transaction.php
#****************************************************************************
$trans["mbrTransactionSuccess"]   = "\$text='รายการที่ทำสำเร็จ';";

#****************************************************************************
#*  Translation text for page mbr_transaction_del_confirm.php
#****************************************************************************
$trans["mbrTransDelConfirmMsg"]   = "\$text='ยืนยันในการลบรายการ';";

#****************************************************************************
#*  Translation text for page mbr_transaction_del.php
#****************************************************************************
$trans["mbrTransactionDelSuccess"] = "\$text='ลบรายการเรียบร้อยแล้ว';";

#****************************************************************************
#*  Translation text for page mbr_print_checkouts.php
#****************************************************************************
$trans["mbrPrintCheckoutsTitle"]  = "\$text='ยืมออกโดย %mbrName%';";
$trans["mbrPrintCheckoutsHdr1"]   = "\$text='เมื่อ:';";
$trans["mbrPrintCheckoutsHdr2"]   = "\$text='สมาชิก:';";
$trans["mbrPrintCheckoutsHdr3"]   = "\$text='หมายเลขสมาชิก (บาร์โค้ด):';";
$trans["mbrPrintCheckoutsHdr4"]   = "\$text='ประเภทสมาชิก:';";
$trans["mbrPrintCloseWindow"]     = "\$text='ปิดหน้าต่างนี้';";

#****************************************************************************
#*  Translation text for page csv_import.php
#****************************************************************************
$trans["CSVImportHeader"]     = "\$text='การนำเข้าข้อมูลสมาชิก';";
$trans["mbrCannotOpenFile"]   = "\$text='ไม่สามารถเปิดไฟล์ได้';";
$trans["mbrCannotUploadFile"] = "\$text='ไม่สามารถอัพโหลดไฟล์ได้';";
$trans["mbrImportCompleted"]  = "\$text='ได้ทำการนำเข้ารายการสมาชิกเรียบร้อยแล้ว';";

# Error message
$trans["Card number is required."]  = "\$text = 'ให้ระบุหมายเลขสมาชิก (บาร์โค้ด)';";
$trans["Card number must be all alphabetic and numeric characters."] = "\$text = 'หมายเลขสมาชิก (บาร์โค้ด) ต้องเป็นตัวอักษรภาษาอังกฤษและตัวเลขเท่านั้น';";
$trans["Last name is required."]       = "\$text = 'ให้ระบุนามสกุล';";
$trans["First name is required."]       = "\$text = 'ให้ระบุชื่อ';";
$trans["Status options is incorrect."] = "\$text = 'ตัวเลือกสถานะสมาชิกไม่ถูกต้อง';";
$trans["Password must be at least 4 characters."]       = "\$text = 'รหัสผ่านต้องมีอย่างน้อย 4 อักขระ';";
$trans["Password must not contain any spaces."]       = "\$text = 'รหัสผ่านต้องไม่เว้นวรรค';";
$trans["Passwords do not match."]       = "\$text = 'ยืนยันรหัสผ่านไม่ถูกต้อง';";
?>