<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Translation text for class Biblio
#****************************************************************************
$trans["biblioError1"]            = "\$text = 'ให้ระบุเลขเรียกหนังสือ';";

#****************************************************************************
#*  Translation text for class BiblioField
#****************************************************************************
$trans["biblioFieldError1"]       = "\$text = 'ให้ระบุข้อมูล';";
$trans["biblioFieldError2"]       = "\$text = 'แท็กต้องเป็นตัวเลข';";

$trans["biblioFieldErrorPictureType"]             = "\$text = 'ชนิดของไฟล์ที่อัพโหลดไม่ใช่รูปภาพ (รองรับ jpeg, gif, png)';";
$trans["biblioFieldErrorPictureLoadFailed"]   = "\$text = 'ไม่สามารถดึงข้อมูลของรูปภาพมาใช้งานได้';";
$trans["biblioFieldErrorCoverLookupFailed"] = "\$text = 'ไม่สามารถเชื่อมต่อกับระบบการค้นหาปกหนังสือได้';";
$trans["biblioFieldErrorDuplicatedISBN"]       = "\$text = 'เลข ISBN นี้ถูกใช้อ้างอิงหนังสืออื่นแล้ว';";
$trans["biblioFieldViewExistingISBN"]            = "\$text = 'เปิดดูหนังสือเล่มนั้น';";
$trans["biblioFieldErrorDuplicatedTitle"]       = "\$text = 'มีทรัพยากรที่ใช้ชื่อเรื่องนี้ไปแล้ว';";
$trans["biblioFieldViewExistingTitle"]            = "\$text = 'เปิดดูทรัพยากรนั้น';";

#****************************************************************************
#*  Translation text for class BiblioQuery
#****************************************************************************
$trans["biblioQueryQueryErr1"]    = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูลบรรณานุกรม';";
$trans["biblioQueryQueryErr2"]    = "\$text = 'เกิดความผิดพลาดในการเข้าถึงเขตข้อมูลบรรณานุกรม';";
$trans["biblioQueryInsertErr1"]   = "\$text = 'เกิดความผิดพลาดในการเพิ่มข้อมูลบรรณานุกรม';";
$trans["biblioQueryInsertErr2"]   = "\$text = 'เกิดความผิดพลาดในการเพิ่มเขตข้อมูลบรรณานุกรม';";
$trans["biblioQueryUpdateErr1"]   = "\$text = 'เกิดความผิดพลาดในการปรับปรุงข้อมูลบรรณานุกรม';";
$trans["biblioQueryUpdateErr2"]   = "\$text = 'เกิดความผิดพลาดในการล้างเขตข้อมูลบรรณานุกรมเพื่อปรับปรุง';";
$trans["biblioQueryDeleteErr"]    = "\$text = 'เกิดความผิดพลาดในการลบข้อมูลบรรณานุกรม';";

#****************************************************************************
#*  Translation text for class BiblioSearchQuery
#****************************************************************************
$trans["biblioSearchQueryErr1"]   = "\$text = 'เกิดความผิดพลาดในการนับผลการสืบค้น';";
$trans["biblioSearchQueryErr2"]   = "\$text = 'เกิดความผิดพลาดในการสืบค้นข้อมูลบรรณานุกรม';";
$trans["biblioSearchQueryErr3"]   = "\$text = 'เกิดความผิดพลาดในการอ่านข้อมูลบรรณานุกรม';";

#****************************************************************************
#*  Translation text for class BiblioCopy
#****************************************************************************
$trans["biblioCopyError1"]        = "\$text = 'ให้ระบุเลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["biblioCopyError2"]        = "\$text = 'เลขทะเบียนหนังสือต้องเป็นตัวอักษร [A-Za-z] หรือตัวเลข';";

#****************************************************************************
#*  Translation text for class BiblioCopyQuery
#****************************************************************************
$trans["biblioCopyQueryErr1"]     = "\$text = 'เกิดความผิดพลาด ให้ตรวจสอบเลขทะเบียนหนังสือ (บาร์โค้ด) ซ้ำ';";
$trans["biblioCopyQueryErr2"]     = "\$text = 'เลขทะเบียนหนังสือ (บาร์โค้ด) %barcodeNmbr% ถูกใช้ไปแล้ว';";
$trans["biblioCopyQueryErr3"]     = "\$text = 'เกิดความผิดพลาดในการเพิ่มรายการตัวเล่ม';";
$trans["biblioCopyQueryErr4"]     = "\$text = 'เกิดความผิดพลาดในการเข้าถึงรายการตัวเล่ม';";
$trans["biblioCopyQueryErr5"]     = "\$text = 'เกิดความผิดพลาดในการปรับปรุงรายการตัวเล่ม';";
$trans["biblioCopyQueryErr6"]     = "\$text = 'เกิดความผิดพลาดในการลบรายการตัวเล่ม';";
$trans["biblioCopyQueryErr7"]     = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูลบรรณานุกรมเพื่อเรียกข้อมูลหมวดหมู่การจัดเก็บ';";
$trans["biblioCopyQueryErr8"]     = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูลหมวดหมู่การจัดเก็บเพื่อตรวจสอบจำนวนวันที่ยืมได้';";
$trans["biblioCopyQueryErr9"]     = "\$text = 'เกิดความผิดพลาดในการตรวจสอบการคืนรายการตัวเล่ม';";
$trans["biblioCopyQueryErr10"]    = "\$text = 'เกิดความผิดพลาดในการตรวจสอบจำนวนจำกัดในการยืม';";
$trans["biblioCopyQueryErr11"]    = "\$text = 'เกิดความผิดพลาดในการอ่านค่าสูงสุดของเลขทะเบียนหนังสือ (บาร์โค้ด)';";

#****************************************************************************
#*  Translation text for class BiblioFieldQuery
#****************************************************************************
$trans["biblioFieldQueryErr1"]    = "\$text = 'เกิดความผิดพลาดในการอ่านเขตข้อมูลบรรณานุกรม';";
$trans["biblioFieldQueryErr2"]    = "\$text = 'เกิดความผิดพลาดในการอ่านเขตข้อมูลบรรณานุกรม';";
$trans["biblioFieldQueryInsertErr"] = "\$text = 'เกิดความผิดพลาดในการเพิ่มเขตข้อมูลบรรณานุกรม';";
$trans["biblioFieldQueryUpdateErr"] = "\$text = 'เกิดความผิดพลาดในการปรับปรุงเขตข้อมูลบรรณานุกรม';";
$trans["biblioFieldQueryDeleteErr"] = "\$text = 'เกิดความผิดพลาดในการลบเขตข้อมูลบรรณานุกรม';";

#****************************************************************************
#*  Translation text for class Dm
#****************************************************************************
$trans["dmErr1"]    = "\$text = 'ให้ระบุรายละเอียด';";
$trans["dmErr2"]    = "\$text = 'ระยะเวลาต้องเป็นตัวเลข';";
$trans["dmErr3"]    = "\$text = 'ระยะเวลาห้ามมีค่าน้อยกว่า 0';";
$trans["dmErr4"]    = "\$text = 'อัตราค่าปรับต้องเป็นตัวเลข';";
$trans["dmErr5"]    = "\$text = 'อัตราค่าปรับห้ามมีค่าน้อยกว่า 0';";
$trans["dmErr6"]    = "\$text = 'ให้ระบุชื่อเขตข้อมูล';";

#****************************************************************************
#*  Translation text for class UsmarcBlockDmQuery
#****************************************************************************
$trans["usmarcBlockDmQueryErr1"]  = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูล MARC บล็อก';";

#****************************************************************************
#*  Translation text for class UsmarcTagDmQuery
#****************************************************************************
$trans["usmarcTagDmQueryErr1"]    = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูล MARC แท็ก';";

#****************************************************************************
#*  Translation text for class UsmarcSubfieldDmQuery
#****************************************************************************
$trans["usmarcSubfldDmQueryErr1"] = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูล MARC เขตข้อมูลย่อย';";

#****************************************************************************
#*  Translation text for class BiblioHoldQuery
#****************************************************************************
$trans["biblioHoldQueryErr1"]     = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูลการจองโดยใช้เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["biblioHoldQueryErr2"]     = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูลการจองโดยใช้หมายเลขสมาชิก (บาร์โค้ด)';";
$trans["biblioHoldQueryErr3"]     = "\$text = 'เกิดความผิดพลาดในการเรียกข้อมูลเลขทะเบียนหนังสือ (บาร์โค้ด) สำหรับจอง';";
$trans["biblioHoldQueryErr4"]     = "\$text = 'เกิดความผิดพลาดในการเพิ่มข้อมูลการจอง';";
$trans["biblioHoldQueryErr5"]     = "\$text = 'เกิดความผิดพลาดในการลบข้อมูลการจอง';";
$trans["biblioHoldQueryErr6"]     = "\$text = 'เกิดความผิดพลาดในการเรียกข้อมูลสมาชิกที่จองรายการตัวเล่มเป็นคนแรก';";

#****************************************************************************
#*  Translation text for class ReportQuery
#****************************************************************************
$trans["reportQueryErr1"]         = "\$text = 'เกิดความผิดพลาดในการออกรายงาน';";

#****************************************************************************
#*  Translation text for class ReportCriteria
#****************************************************************************
$trans["reportCriteriaErr1"]      = "\$text = 'ข้อมูลที่ไม่ใช่ตัวเลขไม่สามารถใช้ได้กับช่องที่ให้ใส่ตัวเลขเท่านั้น';";
$trans["reportCriteriaDateTimeErr"] = "\$text = 'รูปแบบวันที่-เวลาไม่ถูกต้อง';";
$trans["reportCriteriaDateErr"]   = "\$text = 'รูปแบบวันที่ไม่ถูกต้อง';";

#****************************************************************************
#*  Translation text for class LabelFormat and LetterFormat
#****************************************************************************
$trans["labelFormatFontErr"]      = "\$text = 'ชนิดตัวอักษรไม่ถูกต้อง ตัวอักษรที่ถูกต้องคือ Courier, Helvetica, และ Times-Roman';";
$trans["labelFormatFontSizeErr"]  = "\$text = 'ขนาดตัวอักษรไม่ถูกต้อง ขนาดที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatFontSizeErr2"] = "\$text = 'ขนาดตัวอักษรไม่ถูกต้อง ขนาดที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatLMarginErr"]   = "\$text = 'ระยะขอบด้านซ้ายมือไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatLMarginErr2"]  = "\$text = 'ระยะขอบด้านซ้ายมือไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatRMarginErr"]   = "\$text = 'ระยะขอบด้านขวามือไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatRMarginErr2"]  = "\$text = 'ระยะขอบด้านขวามือไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatTMarginErr"]   = "\$text = 'ระยะขอบด้านบนไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatTMarginErr2"]  = "\$text = 'ระยะขอบด้านบนไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatBMarginErr"]   = "\$text = 'ระยะขอบด้านล่างไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatBMarginErr2"]  = "\$text = 'ระยะขอบด้านล่างไม่ถูกต้อง ระยะขอบที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatColErr"]       = "\$text = 'คอลัมน์ไม่ถูกต้อง คอลัมน์ที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatColErr2"]      = "\$text = 'คอลัมน์ไม่ถูกต้อง คอลัมน์ที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatWidthErr"]     = "\$text = 'ความกว้างไม่ถูกต้อง ความกว้างที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatWidthErr2"]    = "\$text = 'ความกว้างไม่ถูกต้อง ความกว้างที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatHeightErr"]    = "\$text = 'ความสูงไม่ถูกต้อง ความสูงที่ถูกต้องจะต้องเป็นตัวเลข';";
$trans["labelFormatHeightErr2"]   = "\$text = 'ความสูงไม่ถูกต้อง ความสูงที่ถูกต้องจะต้องเป็นตัวเลขมากกว่าศูนย์';";
$trans["labelFormatNoLabelsErr"]  = "\$text = 'Invalid label lines specified in label definition xml.';";

#****************************************************************************
#*  Translation text for class BiblioStatusHistQuery
#****************************************************************************
$trans["biblioStatusHistQueryErr1"] = "\$text = 'เกิดความผิดพลาดในการเรียกข้อมูลประวัติการยืมโดยใช้เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["biblioStatusHistQueryErr2"] = "\$text = 'เกิดความผิดพลาดในการเรียกข้อมูลประวัติการยืมโดยใช้หมายเลขสมาชิก (บาร์โค้ด)';";
$trans["biblioStatusHistQueryErr3"] = "\$text = 'เกิดความผิดพลาดในการเพิ่มข้อมูลประวัติการยืม';";
$trans["biblioStatusHistQueryErr4"] = "\$text = 'เกิดความผิดพลาดในการลบประวัติการยืมโดยใช้เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["biblioStatusHistQueryErr5"] = "\$text = 'เกิดความผิดพลาดในการลบประวัติการยืมโดยใช้หมายเลขสมาชิก (บาร์โค้ด)';";

#****************************************************************************
#*  Translation text for class MemberAccountTransaction
#****************************************************************************
$trans["memberAccountTransError1"]  = "\$text = 'ให้ระบุจำนวนเงิน';";
$trans["memberAccountTransError2"]  = "\$text = 'จำนวนเงินต้องเป็นตัวเลข';";
$trans["memberAccountTransError3"]  = "\$text = 'ให้ระบุรายละเอียด';";

#****************************************************************************
#*  Translation text for class MemberAccountQuery
#****************************************************************************
$trans["memberAccountQueryErr1"]    = "\$text = 'เกิดความผิดพลาดในการเข้าถึงข้อมูลสมาชิก';";
$trans["memberAccountQueryErr2"]    = "\$text = 'เกิดความผิดพลาดในการเพิ่มข้อมูลสมาชิก';";
$trans["memberAccountQueryErr3"]    = "\$text = 'เกิดความผิดพลาดในการลบข้อมูลสมาชิก';";

#****************************************************************************
#*  Translation text for class MemberAccountQuery
#****************************************************************************
$trans["CSVErrorInvalidFile"]                   = "\$text = 'เกิดความผิดพลาดในการอัพโหลดเอกสาร';";
$trans["CSVErrorInvalidFileFormat"]                = "\$text = 'ชนิดของไฟล์เอกสารไม่ถูกต้อง';";
$trans["CSVErrorOversized"]                   = "\$text = 'ขนาดของไฟล์เอกสารใหญ่เกินกว่าที่กำหนด';";
$trans["CSVErrorReadFile"]                   = "\$text = 'ไม่สามารถอ่านไฟล์เอกสารที่อัพโหลดได้';";
$trans["CSVErrorMissingHeader"]           = "\$text = 'ฟิลด์หัวข้อใน CSV หายไป';";
$trans["CSVErrorIncorrectHeader"]           = "\$text = 'ฟิลด์บังคับใน CSV ไม่ครบถ้วน';";
$trans["CSVErrorInvalidData"]           = "\$text = 'ข้อมูลใน CSV ผิดพลาด เริ่มตั้งแต่ข้อมูลแถวที่ %line%';";
$trans["CSVErrorMissingRequireField"] = "\$text = 'ไม่พบข้อมูลในฟิลด์บังคับ (ISBN, ชื่อผู้แต่ง, ชื่อเรื่อง) ในข้อมูลแถวที่ %line%';";

#****************************************************************************
#*  Translation text for class Staff
#****************************************************************************
$trans["staffErr1"]    = "\$text = 'ให้ระบุชื่อ';";
$trans["staffErr2"]    = "\$text = 'ให้ระบุนามสกุล';";
$trans["staffErr3"]    = "\$text = 'ชื่อผู้ใช้งานต้องมีอย่างน้อย 4 อักขระ';";
$trans["staffErr4"]    = "\$text = 'ชื่อผู้ใช้งานต้องไม่เว้นวรรค';";
$trans["staffErr5"]    = "\$text = 'รหัสผ่านต้องมีอย่างน้อย 4 อักขระ';";
$trans["staffErr6"]    = "\$text = 'รหัสผ่านต้องไม่เว้นวรรค';";
$trans["staffErr7"]    = "\$text = 'ยืนยันรหัสผ่านไม่ถูกต้อง';";

?>