<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */


#****************************************************************************
#*  Translation text for page index.php, main.php
#****************************************************************************
$trans["indexMainHeading"]       = "\$text='ระบบห้องสมุดอัตโนมัติ<br>OBEC Library Automation System';";
$trans["indexMainIntro"]         = "\$text='กรุณาลงชื่อเข้าใช้ เมนูด้านซ้ายมือ';";
$trans["indexHeading"]       = "\$text='ยินดีต้อนรับสู่ระบบห้องสมุดอัตโนมัติ สพฐ.<br>OBEC Library Automation System';";
$trans["indexIntro"]         = "\$text='ใช้งานแถบเมนูด้านบนเพื่อเข้าสู่ระบบงานห้องสมุด';";
$trans["indexTab"] = "\$text='ระบบงาน';";
$trans["indexDesc"] = "\$text='คำอธิบาย';";
$trans["indexCirc"] = "\$text='งานบริการยืม-คืน<br>(Circulation Module)';";
$trans["indexCircDesc1"] = "\$text='ใช้งานแถบเมนูเพื่อจัดการงานบริการยืม-คืน';";
$trans["indexCircDesc2"] = "\$text='การยืมทรัพยากรห้องสมุด';";
$trans["indexCircDesc3"] = "\$text='การคืนทรัพยากรห้องสมุด';";
$trans["indexCircDesc4"] = "\$text='การเพิ่มสมาชิกใหม่';";
$trans["indexCircDesc5"] = "\$text='การนำเข้าข้อมูลสมาชิก';";
$trans["indexCat"] = "\$text='งานวิเคราะห์ทรัพยากรห้องสมุด<br>(Cataloging Module)';";
$trans["indexCatDesc1"] = "\$text='ใช้งานแถบเมนูเพื่อจัดการงานวิเคราะห์ทรัพยากรห้องสมุด';";
$trans["indexCatDesc2"] = "\$text='การสืบค้นรายการบรรณานุกรม';";
$trans["indexCatDesc3"] = "\$text='การสร้างบรรณานุกรมใหม่';";
$trans["indexCatDesc4"] = "\$text='การลบบรรณานุกรม';";
$trans["indexCatDesc5"] = "\$text='การสืบค้นผ่าน Z39.50';";
$trans["indexCatDesc6"] = "\$text='การควบคุมรายการหลักฐาน (Authority Control)';";
$trans["indexCatDesc7"] = "\$text='การนำเข้าข้อมูลบรรณานุกรม';";
$trans["indexAdmin"] = "\$text='งานจัดการและบริหารระบบ<br>(System Administration Module)';";
$trans["indexAdminDesc1"] = "\$text='ใช้งานแถบเมนูเพื่อจัดการระบบงานจัดการและบริหารระบบ';";
$trans["indexAdminDesc2"] = "\$text='การกำหนดสิทธิ์ผู้ใช้งาน';";
$trans["indexAdminDesc3"] = "\$text='การตั้งค่าห้องสมุด';";
$trans["indexAdminDesc5"] = "\$text='การกำหนดประเภทสมาชิก';";
$trans["indexAdminDesc4"] = "\$text='การกำหนดเขตข้อมูลสมาชิก';";
$trans["indexAdminDesc6"] = "\$text='การกำหนดประเภททรัพยากรห้องสมุด';";
$trans["indexAdminDesc7"] = "\$text='การกำหนดหมวดหมู่การจัดเก็บ';";
$trans["indexAdminDesc8"] = "\$text='การกำหนดระเบียบการยืม-คืน';";
$trans["indexAdminDesc9"] = "\$text='การตั้งค่าการสืบค้นผ่าน Z39.50';";
$trans["indexAdminDesc10"] = "\$text='การเชื่อมโยงเครือข่ายผ่าน Z39.50';";
$trans["indexAdminDesc11"] = "\$text='การนำเข้า/ส่งออกข้อมูล';";
$trans["indexReports"] = "\$text='งานสถิติและรายงาน<br>(Statistics & Reporting Module)';";
$trans["indexReportsDesc1"] = "\$text='ใช้งานแถบเมนูเพื่อจัดการงานสถิติและรายงาน';";
$trans["indexReportsDesc2"] = "\$text='รายงานทะเบียนทรัพยากรห้องสมุด';";
$trans["indexReportsDesc3"] = "\$text='รายงานการยืม-คืน';";
$trans["indexReportsDesc4"] = "\$text='รายงานสถิติห้องสมุด';";
$trans["indexUtility"] = "\$text='งานสนับสนุน<br>(Supporting Module)';";
$trans["indexUtilityDesc1"] = "\$text='ใช้เมนูสำหรับงานพิมพ์ต่างๆ';";
$trans["indexUtilityDesc2"] = "\$text='การพิมพ์บัตรสมาชิก';";
$trans["indexUtilityDesc3"] = "\$text='การพิมพ์เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["indexUtilityDesc4"] = "\$text='การพิมพ์เลขเรียกหนังสือ';";
$trans["indexUtilityDesc5"] = "\$text='การพิมพ์เลขทะเบียนและเลขเรียกหนังสือ';";
$trans["indexOPAC"] = "\$text='การสืบค้นทรัพยากรห้องสมุด<br>(Online Public Access Cataloging Module)';";
$trans["indexOPACDesc1"] = "\$text='ใช้งานแถบเมนูเพื่อสืบค้นทรัพยากรห้องสมุดทั้งภายในห้องสมุดและห้องสมุดอื่นๆ';";
$trans["indexOPACDesc2"] = "\$text='การสืบค้นทรัพยากรห้องสมุด แบ่งออกเป็น 2 แบบ<br>การสืบค้นแบบง่าย (Basic Search)<br>และการสืบค้นแบบขั้นสูง (Advanced Search)';";
$trans["indexOPACDesc3"] = "\$text='การสืบค้นผ่าน Z39.50';";
$trans["indexOPACDesc4"] = "\$text='การใช้งานสำหรับสมาชิก';";

#****************************************************************************
#*  Translation text for page manual.php
#****************************************************************************
$trans["manualMainHeading"]       = "\$text='คู่มือการใช้งานระบบห้องสมุดอัตโนมัติ<br>OBEC Library Automation System';";
$trans["manualMainIntro"]         = "\$text='ใช้โปรแกรม acrobat ในการเปิดดูเอกสาร';";
$trans["manualDesc"] = "\$text='คำอธิบาย';";
$trans["manualDesc1"] = "\$text='งานจัดการและบริหารระบบ';";
$trans["manualDesc2"] = "\$text='งานวิเคราะห์ทรัพยากรห้องสมุด';";
$trans["manualDesc3"] = "\$text='งานบริการยืม - คืน';";
$trans["manualDesc4"] = "\$text='งานสถิติและรายงาน';";
$trans["manualDesc5"] = "\$text='งานสนับสนุน';";
$trans["manualDesc6"] = "\$text='การสืบค้นทรัพยากรห้องสมุด';";
$trans["manualDesc7"] = "\$text='การสำรองข้อมูล';";
$trans["manualDesc8"] = "\$text='การนำเข้าข้อมูลจากโปรแกรมบริการงานห้องสมุด (PLS3)';";
$trans["manualDesc9"] = "\$text='คำถาม – คำตอบ';";
$trans["manualDesc10"] = "\$text='ติดต่อเรา';";
?>