<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Translation text shared by various php files under the navbars dir
#****************************************************************************
$trans["login"]                    = "\$text = 'ลงชื่อเข้าใช้';";
$trans["logout"]                   = "\$text = 'ออกจากระบบ';";
$trans["help"]                     = "\$text = 'การแนะนำการใช้งาน';";
$trans["manual"]                     = "\$text = 'คู่มือการใช้งานระบบ';";

#****************************************************************************
#*  Translation text for page home.php
#****************************************************************************
$trans["homeHomeLink"]             = "\$text = 'หน้าหลัก';";
$trans["homeLicenseLink"]          = "\$text = 'เงื่อนไขการใช้งาน';";
$trans["homeCreditsLink"]           = "\$text = 'รายชื่อผู้พัฒนา';";

#****************************************************************************
#*  Translation text for page admin.php
#****************************************************************************
$trans["adminSummary"]             = "\$text = 'งานจัดการและบริหารระบบ';";
$trans["adminStaff"]               = "\$text = 'การกำหนดสิทธิ์ผู้ใช้งาน';";
$trans["adminSettings"]            = "\$text = 'การตั้งค่าห้องสมุด';";
$trans["adminMaterialTypes"]       = "\$text = 'การกำหนดประเภททรัพยากรห้องสมุด';";
$trans["adminCollections"]         = "\$text = 'การกำหนดหมวดหมู่การจัดเก็บ';";
$trans["adminCheckoutPriv"]     = "\$text = 'การกำหนดระเบียบการยืม-คืน';";
$trans["Cover Lookup Options"]  = "\$text = 'การตั้งค่าระบบสืบค้นปกหนังสือ';";
$trans["adminThemes"]              = "\$text = 'การกำหนดหน้าจอระบบ';";
$trans["adminTranslation"]         = "\$text = 'การแปล';";
$trans["Member Types"]            = "\$text = 'การกำหนดประเภทสมาชิก';";
$trans["Member Fields"]             = "\$text = 'การกำหนดเขตข้อมูลสมาชิก';";
$trans["adminImportExport"]        = "\$text = 'การนำเข้า/ส่งออกข้อมูล';";

#****************************************************************************
#*  Translation text for page cataloging.php
#****************************************************************************
$trans["catalogSummary"]           = "\$text = 'สรุปข้อมูลทรัพยากรห้องสมุด';";
$trans["catalogSearch1"]           = "\$text = 'การสืบค้นรายการบรรณานุกรม';";
$trans["catalogSearch2"]           = "\$text = 'การสืบค้นรายการบรรณานุกรม';";
$trans["catalogResults"]           = "\$text = 'ผลการสืบค้น';";
$trans["catalogBibInfo"]           = "\$text = 'จัดการบรรณานุกรม';";
$trans["catalogBibEdit"]           = "\$text = 'แก้ไขบรรณานุกรม';";
$trans["catalogBibEditMarc"]       = "\$text = 'แก้ไขระเบียน MARC';";
$trans["catalogBibMarcNewFld"]     = "\$text = 'เพิ่มระเบียน MARC ใหม่';";
$trans["catalogBibMarcNewFldShrt"] = "\$text = 'เพิ่มระเบียน MARC ใหม่';";
$trans["catalogBibMarcEditFld"]    = "\$text = 'แก้ไข MARC ';";
$trans["catalogHistory"]       = "\$text = 'ประวัติการยืม';";
$trans["catalogCopyNew"]           = "\$text = 'เพิ่มรายการตัวเล่มฉบับใหม่';";
$trans["catalogCopyEdit"]          = "\$text = 'แก้ไขรายการตัวเล่ม';";
$trans["catalogHolds"]             = "\$text = 'รายการจอง';";
$trans["catalogDelete"]            = "\$text = 'ลบรายการ';";
$trans["catalogBibNewLike"]        = "\$text = 'คัดลอกรายการ';";
$trans["catalogBibNew"]            = "\$text = 'การสร้างบรรณานุกรมใหม่';";
$trans["catalogBibBulkDelete"]  = "\$text = 'การลบบรรณานุกรม';";
$trans["catologAuthority"]       = "\$text = 'การควบคุมรายการหลักฐาน';";
$trans["CSVImport"]                  = "\$text = 'การนำเข้าข้อมูลบรรณานุกรม';";
$trans["Upload Marc Data"]         = "\$text = 'นำเข้ารายการ MARC';";

#****************************************************************************
#*  Translation text for page reports.php
#****************************************************************************
$trans["reportsSummary"]           = "\$text = 'สรุปรายงาน';";
$trans["reportsReportListLink"]    = "\$text = 'สถิติและรายงาน';";
$trans["reportsLabelsLink"]        = "\$text = 'พิมพ์รายการเลขเรียกหนังสือ';";
$trans["reportsLettersLink"]        = "\$text = 'พิมพ์จดหมายแจ้งเตือน';";
$trans["reportsResult"]               = "\$text = 'แสดงรายงาน';";
$trans["reportsCriteria"]               = "\$text = 'เงื่อนไขการแสดงรายงาน';";
$trans["reportsFailedImport"]     = "\$text = 'ทรัพยากรห้องสมุดที่นำเข้าไม่สำเร็จ';";
$trans["reportsNoCover"]            = "\$text = 'ทรัพยากรห้องสมุดที่ไม่มีภาพปก';";
$trans["reportsCataloging"]               = "\$text = 'รายงานทะเบียนทรัพยากรห้องสมุด';";
$trans["reportsCirculation"]               = "\$text = 'รายงานการยืม-คืน';";
$trans["reportsStatistic"]               = "\$text = 'รายงานสถิติห้องสมุด';";

#****************************************************************************
#*  Translation text for page utilities.php
#****************************************************************************
$trans["utilitiesSummary"]           = "\$text = 'งานสนับสนุน';";
$trans["utilitiesCard"]    = "\$text = 'การพิมพ์บัตรสมาชิกห้องสมุด';";
$trans["utilitiesLabel"]    = "\$text = 'การพิมพ์เลขเรียกหนังสือ';";
$trans["utilitiesBarcode"]    = "\$text = 'การพิมพ์เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["utilitiesMixBarcodeLabel"]    = "\$text = 'การพิมพ์เลขทะเบียนและเลขเรียกหนังสือ';";

#****************************************************************************
#*  Translation text for page opac.php
#****************************************************************************

#Added

$trans["memberInfo"]="\$text = 'การใช้งานสำหรับสมาชิก';";
$trans["memberPwd"]           = "\$text = 'เปลี่ยนรหัสผ่าน';";
$trans["memberSearch"]="\$text = 'การยืมทรัพยากรห้องสมุด';";
$trans["editInfo"]="\$text = 'แก้ไขข้อมูลสมาชิก';";
$trans["checkoutHistory"]= "\$text = 'ข้อมูลการยืม';";
$trans["account"]="\$text = 'ข้อมูลค่าปรับ';";
$trans["checkIn"]="\$text = 'การคืนทรัพยากรห้องสมุด';";
$trans["newMember"]= "\$text = 'การเพิ่มสมาชิกใหม่';";
$trans["memberImport"]= "\$text = 'การนำเข้าข้อมูลสมาชิก';";
//$trans["account"]        	= "\$text = 'Account';";
#****************************************************************************
#* Translation text for Amazon mod
#****************************************************************************
$trans["amazon_Search"]             = "\$text = 'ถ่ายโอนข้อมูลจาก Amazon';";
   #****************************************************************************
  #* Translation text for Library of Congress SRU module
  #****************************************************************************
  $trans["LOCsearch"]                 = "\$text = 'ถ่ายโอนข้อมูลจาก Library of Congress';";

#****************************************************************************
#*  Translation text for page lookup.php for lookup2
#****************************************************************************
$trans["lookup"]                = "\$text = 'การสืบค้นผ่าน Z39.50';";
$trans["lookup_opts"]       		= "\$text = 'การตั้งค่าการสืบค้นผ่าน Z39.50';";
$trans["lookup_hosts"]       		= "\$text = 'การเชื่อมโยงเครือข่าย Z39.50';";
$trans["lookup_bulk"]       		= "\$text = 'การสืบค้นจาก ISBN';";
?>