<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

setlocale(LC_MONETARY, 'th_TH.UTF-8'); // For change currency symbol
#****************************************************************************
#*  Common translation text shared among multiple pages
#****************************************************************************
$trans["sharedCancel"]             = "\$text = 'ยกเลิก';";
$trans["sharedDelete"]             = "\$text = 'ลบ';";
$trans["sharedComfirmDelete"]    = "\$text = 'ยืนยันการลบ';";
$trans["sharedDeleteWarning"]    = "\$text = 'การเปลี่ยนแปลงนี้ไม่สามารถเรียกกลับคืนได้ คุณแน่ใจหรือไม่?';";
$trans["sharedRecordIsDeleted"]    = "\$text = 'รายการถูกลบเสร็จสิ้น';";
$trans["sharedRecordsAreDeleted"]    = "\$text = 'รายการถูกลบเสร็จสิ้น';";
$trans["sharedListOfDeletedItems"]    = "\$text = 'รายการที่กำลังจะถูกลบ';";

#****************************************************************************
#*  Translation text for page biblio_view.php
#****************************************************************************
$trans["Are you sure to remove this picture?"]  = "\$text = 'ยืนยันการลบภาพนี้ใช่หรือไม่?';";
$trans["Remove"]  = "\$text = 'ลบภาพออก';";
$trans["biblioViewTble1Hdr"]       = "\$text = 'ข้อมูลบรรณานุกรมหลัก';";
$trans["biblioViewMaterialType"]   = "\$text = 'ประเภททรัพยากรห้องสมุด';";
$trans["biblioViewCollection"]     = "\$text = 'หมวดหมู่การจัดเก็บ';";
$trans["biblioViewCallNmbr"]       = "\$text = 'เลขเรียกหนังสือ';";
$trans["biblioViewTble2Hdr"]       = "\$text = 'จำนวนฉบับ';";
$trans["biblioViewTble2Col1"]      = "\$text = 'เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["biblioViewTble2Col2"]      = "\$text = 'รายละเอียด';";
$trans["biblioViewTble2Col3"]      = "\$text = 'สถานภาพ';";
$trans["biblioViewTble2Col4"]      = "\$text = 'เปลี่ยนแปลงล่าสุดเมื่อ';";
$trans["biblioViewTble2Col5"]      = "\$text = 'กำหนดส่ง';";
$trans["biblioViewTble2ColFunc"]   = "\$text = 'เปลี่ยนแปลง';";
$trans["biblioViewTble2Coldel"]    = "\$text = 'ลบ';";
$trans["biblioViewTble2Coledit"]   = "\$text = 'แก้ไข';";
$trans["biblioViewTble3Hdr"]       = "\$text = 'ข้อมูลบรรณานุกรมเพิ่มเติม';";
$trans["biblioViewNoAddInfo"]      = "\$text = 'ไม่มีข้อมูลบรรณานุกรมอย่างละเอียด';";
$trans["biblioViewNoCopies"]       = "\$text = 'ไมมีรายการตัวเล่ม.';";
$trans["biblioViewOpacFlg"]        = "\$text = 'แสดงใน OPAC';";
$trans["biblioViewLastChange"]        = "\$text = 'บันทึกข้อมูลล่าสุด';";
$trans["biblioViewAACR2"]        = "\$text = 'พิมพ์บัตรรายการ';";
$trans["AACR2"]        = "\$text = 'AACR2';";
$trans["biblioViewNewCopy"]        = "\$text = 'เพิ่มรายการตัวเล่มฉบับใหม่';";
$trans["biblioViewNeweCopy"]       = "\$text = 'Add New Electronic Copy';";
$trans["biblioViewYes"]            = "\$text = 'ใช่';";
$trans["biblioViewNo"]             = "\$text = 'ไม่';";
$trans["biblioViewPictureHeader"]  = "\$text = 'ภาพปกหนังสือ';";

#****************************************************************************
#*  Translation text for page biblio_search.php
#****************************************************************************
$trans["biblioSearchNoResults"]    = "\$text = 'ไม่พบผลลัพธ์จากเงื่อนไขที่ใช้ค้นหา';";
$trans["biblioSearchResults"]      = "\$text = 'ผลการสืบค้น';";
$trans["biblioSearchResultPages"]  = "\$text = 'หน้าผลสืบค้น';";
$trans["biblioSearchFirst"]        = "\$text = 'หน้าแรก';";
$trans["biblioSearchLast"]         = "\$text = 'หน้าสุดท้าย';";
$trans["biblioSearchPrev"]         = "\$text = 'ก่อนหน้านี้';";
$trans["biblioSearchNext"]         = "\$text = 'หน้าถัดไป';";
$trans["biblioSearchResultTxt"]    = "if (%items% == 1) {
                                        \$text = 'พบข้อมูล %items% รายการ';
                                      } else {
                                        \$text = 'พบข้อมูล %items% รายการ';
                                      }";
$trans["biblioSearchauthor"]       = "\$text = ' เรียงตามชื่อผู้แต่ง';";
$trans["biblioSearchtitle"]        = "\$text = ' เรียงตามชื่อเรื่อง';";
$trans["biblioSearchSortByAuthor"] = "\$text = 'เรียงตามชื่อผู้แต่ง';";
$trans["biblioSearchSortByTitle"]  = "\$text = 'เรียงตามชื่อเรื่อง';";
$trans["biblioSearchTitle"]        = "\$text = 'ชื่อเรื่อง';";
$trans["biblioSearchAuthor"]       = "\$text = 'ผู้แต่ง';";
$trans["biblioSearchMaterial"]     = "\$text = 'ประเภททรัพยากรห้องสมุด';";
$trans["biblioSearchCollection"]   = "\$text = 'หมวดหมู่การจัดเก็บ';";
$trans["biblioSearchCall"]         = "\$text = 'เลขเรียกหนังสือ';";
$trans["biblioSearchLink"]         = "\$text = 'หนังสืออิเล็กทรอนิกส์';";
$trans["biblioSearchCopyBCode"]    = "\$text = 'บาร์โค้ด';";
$trans["biblioSearchCopyStatus"]   = "\$text = 'สถานะ';";
$trans["biblioSearchNoCopies"]     = "\$text = 'ไม่มีรายการตัวเล่มฉบับนี้ในระบบ';";
$trans["biblioSearchHold"]         = "\$text = 'จอง';";
$trans["biblioSearchOutIn"]        = "\$text = 'ยืม / คืน';";
$trans["biblioSearchDetail"]       = "\$text = 'ดูรายละเอียดทรัพยากรห้องสมุด';";
$trans["biblioSearchBCode2Chk"]    = "\$text = 'Barcode to Check Out or Check In Form';";
$trans["biblioSearchBCode2Hold"]   = "\$text = 'Barcode to Hold Form';";

#****************************************************************************
#*  Translation text for page advanced_search.php
#****************************************************************************

$trans["advsAdvancedSearch"]       = "\$text = 'การสืบค้นแบบขั้นสูง (Advanced Search)';";
$trans["advsMaterialType"]         = "\$text = 'ประเภททรัพยากรห้องสมุด';"; 
$trans["advsCollectionType"]       = "\$text = 'หมวดหมู่การจัดเก็บ';";
$trans["advsSearch"]               = "\$text = 'ค้นหา';";
$trans["advsClear"]                = "\$text = 'ยกเลิก';";
$trans["advsPublishedYear"]          = "\$text = 'ปีที่พิมพ์';";
$trans["advsLanguage"]                = "\$text = 'ภาษา';";
$trans["optThai"]                = "\$text = 'ไทย';";
$trans["optEnglish"]                = "\$text = 'อังกฤษ';";
$trans["optFrench"]                = "\$text = 'ฝรั่งเศส';";
$trans["optChinese"]                = "\$text = 'จีน';";
$trans["optGerman"]                = "\$text = 'เยอรมัน';";
$trans["optItalian"]                = "\$text = 'อิตาลี';";
$trans["cancel"]                   = "\$text = 'ยกเลิก';";
$trans["or"]                       = "\$text = 'หรือ';";
$trans["any"]                      = "\$text = 'ทุกประเภท';";


#****************************************************************************
#*  Translation text for page loginform.php
#****************************************************************************
$trans["loginFormTbleHdr"]         = "\$text = 'สำหรับผู้ดูแลระบบและผู้ปฏิบัติงาน';";
$trans["loginFormUsername"]        = "\$text = 'รหัสผู้ใช้';";
$trans["loginFormPassword"]        = "\$text = 'รหัสผ่าน';";
$trans["loginFormLogin"]           = "\$text = 'เข้าสู่ระบบ';";

#****************************************************************************
#*  Translation text for page suspended.php
#****************************************************************************
$trans["suspendedUserSuspend"]         = "\$text = 'ผู้ปฏิบัติงานถูกระงับการใช้งาน';";

#****************************************************************************
#*  Translation text for page userloginform.php
#****************************************************************************
$trans["loginFormTbleHdr2"]         = "\$text = 'การใช้งานสำหรับสมาชิก';";
$trans["loginFormDesc1"]         = "\$text = 'ลงชื่อสมาชิกเข้าใช้งานระบบห้องสมุด';";
$trans["loginFormDesc2"]         = "\$text = 'สมาชิกห้องสมุดสามารถเข้าถึงข้อมูลของตนเองได้';";
$trans["loginFormDesc3"]         = "\$text = 'ข้อมูลการยืมทรัพยากรห้องสมุด';";
$trans["loginFormDesc4"]         = "\$text = 'การจองทรัพยากรห้องสมุด';";
$trans["loginFormDesc5"]         = "\$text = 'การเปลี่ยนรหัสผ่าน';";

#****************************************************************************
#*  Translation text for page hold_del_confirm.php
#****************************************************************************
$trans["holdDelConfirmMsg"]        = "\$text = 'ยืนยันลบรายการจองหรือไม่';";

#****************************************************************************
#*  Translation text for page hold_del.php
#****************************************************************************
$trans["holdDelSuccess"]           = "\$text='ลบรายการจองเรียบร้อยแล้ว';";

#****************************************************************************
#*  Translation text for page help_header.php
#****************************************************************************
$trans["helpHeaderTitle"]          = "\$text='การแนะนำการใช้งาน';";
$trans["helpHeaderCloseWin"]       = "\$text='ปิดหน้าต่างนี้';";
$trans["helpHeaderContents"]       = "\$text='เนื้อหา';";
$trans["helpHeaderPrint"]          = "\$text='พิมพ์';";

$trans["catalogResults"]           = "\$text='ผลการสืบค้น';";

#****************************************************************************
#*  Translation text for page authority_header.php
#****************************************************************************
$trans["authorityHeaderTitle"]          = "\$text='การควบคุมรายการหลักฐาน';";

#****************************************************************************
#*  Translation text for page header.php and header_opac.php
#****************************************************************************
$trans["headerTodaysDate"]         = "\$text='เวลาปัจจุบัน:';";

// execute thai date statements
$trans["headerDateFormat"]         = <<<INNERHTML

\$this_date = explode('-', date('D-j-m-Y'));
\$thDay = array(
  'Sun' => 'อาทิตย์',
  'Mon' => 'จันทร์',
  'Tue' => 'อังคาร',
  'Wed' => 'พุธ',
  'Thu' => 'พฤหัส',
  'Fri' => 'ศุกร์',
  'Sat' => 'เสาร์',
);
\$thMonth = array(
  1 => 'ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.', 'พ.ค.', 'มิ.ย.',
  'ก.ค.', 'ส.ค.', 'ก.ย.', 'ต.ค.', 'พ.ย.', 'ธ.ค.');
\$thMonthLong = array(
  1 => 'มกราคม', 'กุมภาพันธ์', 'มีนาคม', 'เมษายน',
  'พฤษภาคม', 'มิถุนายน', 'กรกฎาคม', 'สิงหาคม',
  'กันยายน', 'ตุลาคม', 'พฤศจิกายน', 'ธันวาคม');
  

  
\$text='วัน' . \$thDay[\$this_date[0]] . 'ที่ ' . \$this_date[1] . ' ' . \$thMonthLong[0+\$this_date[2]] . ' พ.ศ.' . (543 + \$this_date[3]);

INNERHTML;
$trans["headerLibraryHours"]       = "\$text='เวลาเปิดบริการ:';";
$trans["headerLibraryPhone"]       = "\$text='ติดต่อ:';";
$trans["headerUser"]       = "\$text='ผู้ใช้งาน';";
#$trans["headerHome"]               = "\$text='หน้าหลัก';";
#$trans["headerCirculation"]        = "\$text='สมาชิกห้องสมุด';";
#$trans["headerCataloging"]         = "\$text='งานลงรายการทรัพยากรห้องสมุด';";
#$trans["headerAdmin"]              = "\$text='งานดูแลระบบ';";
#$trans["headerReports"]            = "\$text='รายงาน';";
$trans["headerHome"]               = "\$text='หน้าหลัก';";
$trans["headerCirculation"]        = "\$text='งานบริการยืม-คืน';";
$trans["headerCataloging"]         = "\$text='งานวิเคราะห์ทรัพยากรห้องสมุด';";
$trans["headerAdmin"]              = "\$text='งานจัดการและบริหารระบบ';";
$trans["headerReports"]            = "\$text='งานสถิติและรายงาน';";
$trans["headerUtilities"]            = "\$text='งานสนับสนุน';";
#****************************************************************************
#*  Translation text for page footer.php
#****************************************************************************
$trans["footerLibraryHome"]        = "\$text='หน้าหลักห้องสมุด';";
$trans["footerOPAC"]               = "\$text='การสืบค้นทรัพยากรห้องสมุด';";
$trans["footerHelp"]               = "\$text='แนะนำการใช้งาน';";
$trans["footerPoweredBy"]          = "\$text='พัฒนาเพิ่มเติมโดย นายประสิทธิชัย เลิศรัตนเคหกาล จาก OpenBiblio รุ่น';";
$trans["footerDatabaseVersion"]    = "\$text='เลขรุ่นฐานข้อมูล';";
$trans["footerCopyright"]          = "\$text='สงวนลิขสิทธิ์';";
$trans["footerUnderThe"]           = "\$text='ซอร์สโค้ดอยู่ภายใต้ลิขสิทธิ์';";
$trans["footerGPL"]                = "\$text='GNU General Public License';";

?>