<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Common translation text shared among multiple pages
#****************************************************************************
$trans["utilitiesCancel"]              = "\$text = 'ยกเลิก';";
$trans["utilitiesSubmit"]                          = "\$text = 'แสดงผลลัพธ์';";

#****************************************************************************
#*  Translation text for page index.php
#****************************************************************************
$trans["indexHdr"]                 = "\$text = 'งานสนับสนุน';";
$trans["indexDesc"]                = "\$text = 'บรรณารักษ์ จัดพิมพ์บัตรสมาชิก เลขทะเบียนหนังสือ (บาร์โค้ด) และเลขเรียกหนังสือ โดยเลือกเมนูที่ต้องการพิมพ์จากด้านซ้ายมือ';";

#****************************************************************************
#*  Translation text for page card_form.php
#****************************************************************************
$trans["utilitiesCard_formHdr"]                 = "\$text = 'การพิมพ์บัตรสมาชิกห้องสมุด';";

#****************************************************************************
#*  Translation text for page barcode_form.php
#****************************************************************************
$trans["utilitiesBarcode_formHdr"]                 = "\$text = 'การพิมพ์เลขทะเบียนหนังสือ (บาร์โค้ด)';";

#****************************************************************************
#*  Translation text for page label_form.php
#****************************************************************************
$trans["utilitiesLabel_formHdr"]                 = "\$text = 'การพิมพ์เลขเรียกหนังสือ';";

#****************************************************************************
#*  Translation text for page label_form.php
#****************************************************************************
$trans["utilitiesBarcodeLabel_formHdr"]                 = "\$text = 'การพิมพ์เลขทะเบียนและเลขเรียกหนังสือ';";

#****************************************************************************
#*  Translation text for page noauth.php
#****************************************************************************
$trans["noauthMsg"]                = "\$text = 'คุณไม่มีสิทธิ์สำหรับการใช้งานในส่วนนี้';";

#****************************************************************************
#*  Column Text
#****************************************************************************
$trans["barcode_nmbr"] = "\$text = 'เลขทะเบียนหนังสือ (บาร์โค้ด)';";
$trans["bib_name"]  = "\$text = 'ชื่อเรื่อง';";
$trans["member_name"]  = "\$text = 'ชื่อสมาชิก';";

$trans["reportDateMonth01"]   = "\$text = 'มกราคม';";
$trans["reportDateMonth02"]   = "\$text = 'กุมภาพันธ์';";
$trans["reportDateMonth03"]   = "\$text = 'มีนาคม';";
$trans["reportDateMonth04"]   = "\$text = 'เมษายน';";
$trans["reportDateMonth05"]   = "\$text = 'พฤษภาคม';";
$trans["reportDateMonth06"]   = "\$text = 'มิถุนายน';";
$trans["reportDateMonth07"]   = "\$text = 'กรกฎาคม';";
$trans["reportDateMonth08"]   = "\$text = 'สิงหาคม';";
$trans["reportDateMonth09"]   = "\$text = 'กันยายน';";
$trans["reportDateMonth10"]   = "\$text = 'ตุลาคม';";
$trans["reportDateMonth11"]   = "\$text = 'พฤศจิกายน';";
$trans["reportDateMonth12"]   = "\$text = 'ธันวาคม';";

$trans["Sort By"]                       = "\$text = 'เรียงตาม';";
$trans["utilitiesReverse"]        = "\$text = '(มากไปน้อย)';";
?>