<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  session_cache_limiter(null);

  $tab = "reports";
  $nav = "index_statistic";
  $focus_form_name = "barcodeform";
  $focus_form_field = "rpt_barcode";

  require_once("../functions/inputFuncs.php");
  require_once("../functions/formatFuncs.php");
  require_once("../shared/logincheck.php");
  require_once("../classes/BiblioSearch.php");
  require_once("../classes/BiblioSearchQuery.php");
  require_once("../functions/searchFuncs.php");
  require_once("../classes/Dm.php");
  require_once("../classes/DmQuery.php");
  require_once("../shared/header.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);
#  $loc = new Localize(OBIB_LOCALE,'admin');
  $admloc = new Localize(OBIB_LOCALE,'admin');

  #****************************************************************************
  #*  Search database for member
  #****************************************************************************

?>
<?
  #****************************************************************************
  #*  Search database for member classify
  #****************************************************************************
  $dmQ = new DmQuery();
  $dmQ->connect();
  $dms = $dmQ->getWithStats("mbr_classify_dm");
#  $dmQ->close();
?>
<h1><?php echo $loc->getText("statisticMemberClassification"); ?></h1>
<table class="primary">
  <tr>
    <th valign="top">
      <?php echo $admloc->getText("Description"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("Max. Fines"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("Members"); ?>
    </th>
  </tr>
  <?php
    $row_class = "primary";
    foreach ($dms as $dm) {
  ?>
  <tr>
    <td valign="top" class="<?php echo H($row_class);?>">
      <?php echo H($dm->getDescription());?>
    </td>
    <td valign="top" class="<?php echo H($row_class);?>">
      <?php echo H($dm->getMaxFines());?>
    </td>
    <td valign="top" align="center"  class="<?php echo H($row_class);?>">
      <?php echo H($dm->getCount());?>
    </td>
  </tr>
  <?php
    }
  ?>
</table>

<?
  #****************************************************************************
  #*  Search database for material
  #****************************************************************************
  $dms = $dmQ->getWithStats("material_type_dm");
?>
<h1><?php echo $loc->getText("statisticMaterialType"); ?></h1>
<table class="primary">
  <tr>
    <th valign="top" nowrap="yes">
      <?php echo $admloc->getText("admin_materials_listDescription"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("admin_materials_listImageFile"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("admin_materials_listBibcount"); ?>
    </th>
  </tr>
  <?php
    $row_class = "primary";
    foreach ($dms as $dm) {
  ?>
  <tr>
    <td valign="top" class="<?php echo H($row_class);?>">
      <?php echo H($dm->getDescription());?>
    </td>
    <td valign="top" class="<?php echo H($row_class);?>">
      <img src="../images/<?php echo HURL($dm->getImageFile());?>" width="20" height="20" align="middle" alt="<?php echo H($dm->getDescription());?>">
      <?php echo H($dm->getImageFile());?>
    </td>
    <td valign="top" align="center"  class="<?php echo H($row_class);?>">
      <?php echo H($dm->getCount());?>
    </td>
  </tr>
  <?php
    }
  ?>
</table>

<?
  #****************************************************************************
  #*  Search database for collection
  #****************************************************************************
  $dms = $dmQ->getWithStats("collection_dm");
?>
<h1><?php echo $loc->getText("statisticCollection"); ?></h1>
<table class="primary">
  <tr>
    <th valign="top">
      <?php echo $admloc->getText("adminCollections_listDescription"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("adminCollections_listDaysdueback"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("adminCollections_listDailylatefee"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("adminCollections_listBibliographycount"); ?>
    </th>
  </tr>
  <?php
    $row_class = "primary";
    foreach ($dms as $dm) {
  ?>
  <tr>
    <td valign="top" class="<?php echo H($row_class);?>">
      <?php echo H($dm->getDescription());?>
    </td>
    <td valign="top" align="center" class="<?php echo H($row_class);?>">
      <?php echo H($dm->getDaysDueBack());?>
    </td>
    <td valign="top" align="center" class="<?php echo H($row_class);?>">
      <?php echo H(moneyFormat($dm->getDailyLateFee(),2)); ?>
    </td>
    <td valign="top" align="center"  class="<?php echo H($row_class);?>">
      <?php echo H($dm->getCount());?>
    </td>
  </tr>
  <?php
    }
  ?>
</table>

<?
  #****************************************************************************
  #*  Search database for staff
  #****************************************************************************
  $dms = $dmQ->getWithStats("staff_catalog_dm");
?>
<h1><?php echo $loc->getText("statisticStaffCatalog"); ?></h1>
<table class="primary">
  <tr>
    <th valign="top">
      <?php echo $admloc->getText("adminCollections_listDescription"); ?>
    </th>
    <th valign="top">
      <?php echo $admloc->getText("adminCollections_listBibliographycount"); ?>
    </th>
  </tr>
  <?php
    $row_class = "primary";
    foreach ($dms as $dm) {
  ?>
  <tr>
    <td valign="top" class="<?php echo H($row_class);?>">
      <?php echo H($dm->getDescription());?>
    </td>
    <td valign="top" align="center"  class="<?php echo H($row_class);?>">
      <?php echo H($dm->getCount());?>
    </td>
  </tr>
  <?php
    }
  ?>
</table>

<?php include("../shared/footer.php"); ?>
