<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../classes/Localize.php");
  $headerLoc = new Localize(OBIB_LOCALE,"shared");

// code html tag with language attribute if specified.
echo "<html";
if (OBIB_HTML_LANG_ATTR != "") {
  echo " lang=\"".H(OBIB_HTML_LANG_ATTR)."\"";
}
echo ">\n";
echo "<head>\n";
// code character set if specified
if (OBIB_CHARSET != "") { ?>
  <meta http-equiv="content-type" content="text/html; charset=<?php echo H(OBIB_CHARSET); ?>">
<?php } ?>
  <meta name="description" content="OpenBiblio Library Automation System">

<link href="../css/style.css" rel="stylesheet" type="text/css" media="screen" />
<style type="text/css">
  <?php include("../css/style.php");?>
</style>
<?php    
  if (!isset($_SESSION["active_theme"])) {
    require_once("../shared/theme.php");
    $_SESSION["active_theme"] = get_active_theme();
  }
  if (strcmp($_SESSION["active_theme"], "") != 0) {
    echo '<link href="../themes/'. $_SESSION["active_theme"] .'/style.css" rel="stylesheet" type="text/css" media="screen" />';
  }
?>
<title><?php echo OBIB_LIBRARY_PREFIX_NAME.H(OBIB_LIBRARY_NAME);?></title>
<script language="JavaScript">
<!--
function popSecondary(url) {
    var SecondaryWin;
    SecondaryWin = window.open(url,"secondary","resizable=yes,scrollbars=yes,width=535,height=400");
    self.name="main";
}
function popSecondaryLarge(url) {
    var SecondaryWin;
    SecondaryWin = window.open(url,"secondary","toolbar=yes,resizable=yes,scrollbars=yes,width=700,height=500");
    self.name="main";
}
function backToMain(URL) {
    var mainWin;
    mainWin = window.open(URL,"main");
    mainWin.focus();
    this.close();
}
-->
</script>
<?php
	## ---------------------------------------------------------------------
	## --- added for Fred LaPlante's Lookup Function -----------------------
	if (file_exists('customHead.php')) {
		include ('customHead.php');
	}
	## ---------------------------------------------------------------------
?>
  <script type="text/javascript" src="../scripts/jquery.js"></script>
  <script type="text/javascript" src="../scripts/jquery.collapsible.js"></script>
<?php
    if (file_exists('../scripts/locale/'. OBIB_LOCALE .'.js')) {
      $js_filename = OBIB_LOCALE .'.js'; 
    } else {
      $js_filename = 'en.js';
    }
?>
  <script type="text/javascript" src="../scripts/locale/<?php echo $js_filename; ?>"></script>
  <script type="text/javascript" src="../scripts/search.js"></script>
</head>
<body bgcolor="<?php echo H(OBIB_PRIMARY_BG);?>" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" marginheight="0" marginwidth="0" <?php
  if (isset($focus_form_name) && ($focus_form_name != "")) {
    if (preg_match('/^[a-zA-Z0-9_]+$/', $focus_form_name)
        && preg_match('/^[a-zA-Z0-9_]+$/', $focus_form_field)) {
      echo 'onLoad="self.focus();document.'.$focus_form_name.".".$focus_form_field.'.focus()"';
    }
  } ?>>
<!-- **************************************************************************************
     * Library Name and hours
     **************************************************************************************-->
<table class="primary" width="100%" cellpadding="0" cellspacing="0" border="0">
  <tr bgcolor="<?php echo H(OBIB_TITLE_BG);?>">
    <td width="100%" class="title" valign="top" style="background:url(../images/bg_header.jpg) center top repeat-x">
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="55"><img src="../images/shim.gif" width="55" height="10" /></td>
        <td width="204" align="center">
		       <?php
         if (OBIB_LIBRARY_IMAGE_URL != "") {
           echo "<img align=\"middle\" src=\"".H(OBIB_LIBRARY_IMAGE_URL)."\" border=\"0\">";
         }
       ?></td>
        <td class="title"><?php
         if (!OBIB_LIBRARY_USE_IMAGE_ONLY) {
           echo OBIB_LIBRARY_PREFIX_NAME.H(OBIB_LIBRARY_NAME);
         }
       ?><img src="../images/shim.gif" width="55" height="10" /></td>
        <td width="55"><img src="../images/shim.gif" width="55" height="10" /></td>
      </tr>
    </table>
    </td>
  </tr>
</table>
<!-- **************************************************************************************
     * Tabs
     **************************************************************************************-->
<div id="TaBZ">
	<ul>
		<li id="tab1"<?php if ($tab == "home") { echo " class=\"current\""; } ?>><a href="../home/index.php"><?php echo $headerLoc->getText("headerHome"); ?></a></li>
		<li id="tab2"<?php if ($tab == "cataloging") { echo " class=\"current\""; } ?>><a href="../catalog/index.php"><?php echo $headerLoc->getText("headerCataloging"); ?></a></li>
		<li id="tab3"<?php if ($tab == "circulation") { echo " class=\"current\""; } ?>><a href="../circ/index.php"><?php echo $headerLoc->getText("headerCirculation"); ?></a></li>
		<li id="tab4"<?php if ($tab == "reports") { echo " class=\"current\""; } ?>><a href="../reports/index.php"><?php echo $headerLoc->getText("headerReports"); ?></a></li>
		<li id="tab5"<?php if ($tab == "utilities") { echo " class=\"current\""; } ?>><a href="../utilities/index.php"><?php echo $headerLoc->getText("headerUtilities"); ?></a></li>
		<li id="tab6"<?php if ($tab == "admin") { echo " class=\"current\""; } ?>><a href="../admin/index.php"><?php echo $headerLoc->getText("headerAdmin"); ?></a></li>
<?php
if (OBIB_OPAC_URL != "") {
?>
		<li id="tab7"><a href="<?php echo H(OBIB_OPAC_URL);?>" target="_blank"><?php echo $headerLoc->getText("footerOPAC"); ?></a></li>
<?php
}
?>
	</ul>
</div>