﻿<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  require_once("../classes/Member.php");
  require_once("../classes/MemberQueryOpac.php");
  require_once("../classes/SessionQuery.php");
  require_once("../functions/errorFuncs.php");

  #****************************************************************************
  #*  Checking for post vars.  Go back to form if none found.
  #****************************************************************************
  $pageErrors = "";
  if (count($_POST) == 0) {
    header("Location: ../shared/userloginform.php");
    exit();
  }

  #****************************************************************************
  #*  Username edits
  #****************************************************************************
  $username = $_POST["username"];
  if ($username == "") {
    $error_found = true;
    $pageErrors["username"] = "ต้องป้อนชื่อผู้ใช้";
  }

  #****************************************************************************
  #*  Password edits
  #****************************************************************************
  $error_found = false;
  $pwd = $_POST["pwd"];
  if ($pwd == "") {
    $error_found = true;
    $pageErrors["pwd"] = "ต้องป้อนรหัสผ่าน";
  } else {


    $memberQ = new MemberQuery();
    $memberQ->connect();
    if ($memberQ->errorOccurred()) {
      displayErrorPage($memberQ);
    }
    $memberQ->verifySignon($username, $pwd);
    if ($memberQ->errorOccurred()) {
      displayErrorPage($memberQ);
    }
    $member = $memberQ->fetchMember();
    if ($member == false) {
      # invalid password.  Add one to login attempts.
      $error_found = true;
      $pageErrors["pwd"] = "รหัสผ่านไม่ถูกต้อง";
      if (!isset($_SESSION["loginAttempts"]) || ($_SESSION["loginAttempts"] == "")) {
        $sess_login_attempts = 1;
      } else {
        $sess_login_attempts = $_SESSION["loginAttempts"] + 1;
      }
    }
    $memberQ->close();
  }

  #****************************************************************************
  #*  Redirect back to form if error occured
  #****************************************************************************
  if ($error_found == true) {
    $_SESSION["postVars"] = $_POST;
    $_SESSION["pageErrors"] = $pageErrors;
    header("Location: ../shared/userloginform.php");
    exit();
  }

  #**************************************************************************
  #*  Insert new session row with random token
  #**************************************************************************

  $sessionQ = new SessionQuery();
  $sessionQ->connect();
  if ($sessionQ->errorOccurred()) {
    $sessionQ->close();
    displayErrorPage($sessionQ);
  }
  $token = $sessionQ->getToken($member->getMbrid());
  if ($token == false) {
    $sessionQ->close();
    displayErrorPage($sessionQ);
  }
  $sessionQ->close();

  #**************************************************************************
  #*  Destroy form values and errors and reset signon variables
  #**************************************************************************
  unset($_SESSION["postVars"]);
  unset($_SESSION["pageErrors"]);

  $_SESSION["username"] = $member->getFirstLastName();
  $_SESSION["mbrid"] = $member->getMbrid();
  $_SESSION["mbrtoken"] = $token;
   unset($_SESSION["userid"]);
   unset($_SESSION["token"]);
  $_SESSION["loginAttempts"] = 0;
  $_SESSION["hasAdminAuth"] = false;
  $_SESSION["hasCircAuth"] = true;
  $_SESSION["hasCircMbrAuth"] = false;
  $_SESSION["hasCatalogAuth"] = false;
  $_SESSION["hasReportsAuth"] = false;

  #**************************************************************************
  #*  Redirect to return page
  #**************************************************************************
#  header("Location: ".$_SESSION["returnPage"]);
  header("Location: ../opac/patron_view.php");
  exit();

?>
