<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  $tab = "catalog";
  $nav = "view";

  #****************************************************************************
  #*  Checking for get vars.  Go back to form if none found.
  #****************************************************************************
  if (count($_GET) == 0) {
    header("Location: ../catalog/index.php");
    exit();
  }

  require_once("../classes/Biblio.php");
  require_once("../classes/BiblioQuery.php");
  require_once("../classes/BiblioCopy.php");
  require_once("../classes/BiblioCopyQuery.php");
  require_once("../classes/DmQuery.php");
  require_once("../classes/UsmarcTagDm.php");
  require_once("../classes/UsmarcTagDmQuery.php");
  require_once("../classes/UsmarcSubfieldDm.php");
  require_once("../classes/UsmarcSubfieldDmQuery.php");
  require_once("../functions/marcFuncs.php");
  require_once("../classes/Localize.php");
#  $loc = new Localize(OBIB_LOCALE,"shared");


  #****************************************************************************
  #*  Retrieving get var
  #****************************************************************************
  $bibid = $_GET["bibid"];
  if (isset($_GET["msg"])) {
    $msg = "<font class=\"error\">".H($_GET["msg"])."</font><br><br>";
  } else {
    $msg = "";
  }

  #****************************************************************************
  #*  Loading a few domain tables into associative arrays
  #****************************************************************************
  $dmQ = new DmQuery();
  $dmQ->connect();
  $collectionDm = $dmQ->getAssoc("collection_dm");
  $materialTypeDm = $dmQ->getAssoc("material_type_dm");
  $biblioStatusDm = $dmQ->getAssoc("biblio_status_dm");
  $dmQ->close();

  $marcTagDmQ = new UsmarcTagDmQuery();
  $marcTagDmQ->connect();
  if ($marcTagDmQ->errorOccurred()) {
    $marcTagDmQ->close();
    displayErrorPage($marcTagDmQ);
  }
  $marcTagDmQ->execSelect();
  if ($marcTagDmQ->errorOccurred()) {
    $marcTagDmQ->close();
    displayErrorPage($marcTagDmQ);
  }
  $marcTags = $marcTagDmQ->fetchRows();
  $marcTagDmQ->close();

  $marcSubfldDmQ = new UsmarcSubfieldDmQuery();
  $marcSubfldDmQ->connect();
  if ($marcSubfldDmQ->errorOccurred()) {
    $marcSubfldDmQ->close();
    displayErrorPage($marcSubfldDmQ);
  }
  $marcSubfldDmQ->execSelect();
  if ($marcSubfldDmQ->errorOccurred()) {
    $marcSubfldDmQ->close();
    displayErrorPage($marcSubfldDmQ);
  }
  $marcSubflds = $marcSubfldDmQ->fetchRows();
  $marcSubfldDmQ->close();


  #****************************************************************************
  #*  Search database
  #****************************************************************************
  $biblioQ = new BiblioQuery();
  $biblioQ->connect();
  if ($biblioQ->errorOccurred()) {
    $biblioQ->close();
    displayErrorPage($biblioQ);
  }
  if (!$biblio = $biblioQ->doQuery($bibid)) {
    $biblioQ->close();
    displayErrorPage($biblioQ);
  }
  $biblioFlds = $biblio->getBiblioFields();

  #**************************************************************************
  #*  Show bibliography info.
  #**************************************************************************
#$materialTypeName = iconv('utf-8','tis-620',H($materialTypeDm[$biblio->getMaterialCd()]));
#$collectionName = iconv('utf-8','tis-620',H($collectionDm[$biblio->getCollectionCd()]));
$callNumber1 = iconv('utf-8','tis-620',$biblio->getCallNmbr1());
$callNumber2 = iconv('utf-8','tis-620',$biblio->getCallNmbr2());
$callNumber3 = iconv('utf-8','tis-620',$biblio->getCallNmbr3());
$author = '';
$responseAuthor = '';
if (isset($biblioFlds["020a"])) {
	$isbn = '     ISBN : '.iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["020a"]->getFieldData())));
}
if (isset($biblioFlds["100a"])) {
	$marc100a = iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["100a"]->getFieldData())));
	$author = iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["100a"]->getFieldData())));
	$resAuthor = ' / '.iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["100a"]->getFieldData())));
}
if (isset($biblioFlds["110a"])) {
	$marc110a = ''.iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["110a"]->getFieldData())));
	if ($marc100a == '') {
		$author = iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["110a"]->getFieldData())));
		$resAuthor = ' / '.iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["110a"]->getFieldData())));
	}
}
if (isset($biblioFlds["111a"])) {
	$marc111a = ''.iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["111a"]->getFieldData())));
	if (($marc100a == '') && ($marc110a == '')) {
		$author = iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["111a"]->getFieldData())));
		$resAuthor = ' / '.iconv('utf-8','tis-620', trim(str_replace('.', '', $biblioFlds["111a"]->getFieldData())));
	}
}
if (isset($biblioFlds["245a"])) {
	$marc245a = iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["245a"]->getFieldData())));
}
if (isset($biblioFlds["245b"])) {
#	$marc245b = ' = '.iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["245b"]->getFieldData())));
	$marc245b = iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["245b"]->getFieldData())));
}
if (isset($biblioFlds["245c"])) {
	if ($author <> '') {
#		$marc245c = ' '.iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["245c"]->getFieldData())));
		$marc245c = ' '.iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["245c"]->getFieldData())));
	} else {
		$marc245c = ' / '.iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["245c"]->getFieldData())));
	}
}
if (isset($biblioFlds["250a"])) {
	$marc250a = iconv('utf-8','tis-620',trim(str_replace('.', '',$biblioFlds["250a"]->getFieldData()))).'. -- ';
}
if (isset($biblioFlds["260a"])) {
	$marc260a = iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["260a"]->getFieldData()))).' : ';
}
if (isset($biblioFlds["260b"])) {
	$marc260b = iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["260b"]->getFieldData()))).', ';
}
if (isset($biblioFlds["260c"])) {
	$marc260c = iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["260c"]->getFieldData()))).'. ';
}
if (isset($biblioFlds["300a"])) {
	$marc300a = iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["300a"]->getFieldData())));
}
if (isset($biblioFlds["300b"])) {
	$marc300b = ' : '.iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["300b"]->getFieldData())));
}
if (isset($biblioFlds["300c"])) {
	$marc300c = ' ; '.iconv('utf-8','tis-620',trim($biblioFlds["300c"]->getFieldData()));
}
if (isset($biblioFlds["300e"])) {
	$marc300e = ' + '.iconv('utf-8','tis-620',trim(str_replace('.', '', $biblioFlds["300e"]->getFieldData())));
}
$seq = 0;
if (isset($biblioFlds["650a"])) {
	$seq++;
	$marc650a1 = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["650a"]->getFieldData()))).'.';
}
if (isset($biblioFlds["650a1"])) {
	$seq++;
	$marc650a2 = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["650a1"]->getFieldData()))).'.';
}
if (isset($biblioFlds["650a2"])) {
	$seq++;
	$marc650a3 = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["650a2"]->getFieldData()))).'.';
}
if (isset($biblioFlds["650a3"])) {
	$seq++;
	$marc650a4 = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["650a3"]->getFieldData()))).'.';
}
if (isset($biblioFlds["650a4"])) {
	$seq++;
	$marc650a5 = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["650a4"]->getFieldData()))).'.';
}
if (isset($biblioFlds["700a"])) {
	$seq++;
	$marc700a = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["700a"]->getFieldData()))).'.';
}
if (isset($biblioFlds["710a"])) {
	$seq++;
	$marc710a = iconv('utf-8','tis-620',"  $seq. ".trim(str_replace('.', '', $biblioFlds["710a"]->getFieldData()))).'.';
}
$seq++;
$marcTitle = "  $seq. ͧ.";

define('FPDF_FONTPATH','fpdf/font/');

require_once('fpdf/fpdf_thai.php');

##############################################################################
$pdf=new FPDF_Thai('P', 'mm', array(200,295));

$initX = 20;
$initY = 10;
$lineH = 6;

//Data loading
$pdf->AddFont('niramit','','niramit.php');
#$pdf->AddFont('niramit','B','niramitb.php');

#$pdf->SetMargins(6, 10, 6);
#$pdf->SetAutoPageBreak(false, 10);
###################################################################################################################

$pdf->AddPage();
$pdf->SetFillColor(255,255,255);

$pdf->SetXY($initX,$initY);
$pdf->SetFont('niramit','',16);
$pdf->Cell(21,$lineH,$callNumber1,0,0,'L');
$pdf->Ln();
$pdf->SetX($initX);
$pdf->Cell(21,$lineH,$callNumber2,0,0,'L');
$pdf->Ln();
$pdf->SetX($initX);
$pdf->Cell(21,$lineH,$callNumber3,0,0,'L');
$pdf->Ln();
#$pdf->SetFillColor(0,0,0);
$pdf->SetXY($initX+21,$initY);
if ($author <> '') {
	$pdf->Cell(139,$lineH,$author.'.','',0,'L');
	$pdf->Ln();
	$pdf->SetX($initX+21);
	$noAuthor = '     ';
} else {
	$noAuthor = '';
}
$pdf->MultiCell(139,$lineH,$noAuthor.$marc245a.$marc245b.$resAuthor.$marc245c.'. -- '.$marc250a.$marc260a.$marc260b.$marc260c,'',0,'L');
$pdf->SetX($initX+21);
$pdf->MultiCell(139,$lineH,'     '.str_replace('..', '.', $marc300a.$marc300b.$marc300c.$marc300e.'.'),'',0,'L');
if ($isbn <> '') {
	$pdf->SetX($initX);
	$pdf->Cell(21,$lineH,'',0,0,'L');
	$pdf->Cell(139,$lineH,$isbn,'',0,'L');
	$pdf->Ln();
}
$pdf->SetX($initX+21);
$pdf->MultiCell(139,$lineH,'   '.$marc650a1.$marc650a2.$marc650a3.$marc650a4.$marc650a5.$marc700a.$marc710a.$marcTitle,'',0,'L');
#$pdf->Rect($initX,$initY,21,25);
#$pdf->Rect($initX,$initY,85,105);
//-----------------------------------
$pdf->Output();
ob_end_flush();
?>