<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  session_cache_limiter(null);

  $tab = "utilities";
  $nav = "barcode";
  $focus_form_name = "barcodeform";
  $focus_form_field = "rpt_barcode";

  require_once("../functions/inputFuncs.php");
  require_once("../shared/logincheck.php");
  require_once("../shared/header.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);
  $rptloc = new Localize(OBIB_LOCALE,"reports");

?>
<h1><?php echo $loc->getText("utilitiesBarcode_formHdr"); ?></h1>

<form name="barcodeform" method="POST" action="../utilities/barcode_print.php" target="_blank">
<table class="rpt_params">
<tr class="rpt_param"><td><label for="rpt_barcode"><?php echo $rptloc->getText("Barcode"); ?></label></td><td><?php echo inputField("textarea", "rpt_barcode", $value="", $attrs=array("rows" => "5","cols" => "30")); ?></td></tr>
<tr class="rpt_param"><td><label for="rpt_newer"><?php echo $rptloc->getText("Newer than"); ?></label></td><td><?php echo inputField("date", "rpt_newer", $value=""); ?></td></tr>
<tr class="rpt_param"><td><label for="rpt_older"><?php echo $rptloc->getText("Older than"); ?></label></td><td><?php echo inputField("date", "rpt_older", $value=""); ?></td></tr>
<tr class="rpt_param"><td><label for="rpt_order_by"><?php echo $rptloc->getText("Sort By"); ?>:</label></td><td><select id="rpt_order_by" name="rpt_order_by" onChange="modified=true" >
<option value="barcode_nmbr"  selected><?php echo $rptloc->getText("Barcode"); ?></option>
<!--option value="barcode_nmbr!r" ><?php echo $rptloc->getText("Barcode"); ?> <?php echo $loc->getText("utilitiesReverse"); ?></option-->
<option value="title" ><?php echo $rptloc->getText("Title"); ?></option>
<!--option value="title!r" ><?php echo $rptloc->getText("Title"); ?> <?php echo $loc->getText("utilitiesReverse"); ?></option-->
</select>
</td></tr>
</table>
<input type="submit" value="  <?php echo $loc->getText("utilitiesSubmit"); ?>  " class="button">
</form>


<?php include("../shared/footer.php"); ?>
