<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  $tab = "utilities";

  require_once("../functions/inputFuncs.php");
  require_once("../functions/formatFuncs.php");
  require_once("../shared/logincheck.php");
  require_once("../classes/BiblioSearch.php");
  require_once("../classes/BiblioSearchQuery.php");
  require_once("../functions/searchFuncs.php");
  require_once("../classes/DmQuery.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);

  #****************************************************************************
  #*  Retrieving get var
  #****************************************************************************
  $bibid = $_POST["bibid"];
  if (isset($_GET["msg"])) {
    $msg = "<font class=\"error\">".H($_GET["msg"])."</font><br><br>";
  } else {
    $msg = "";
  }

  #****************************************************************************
  #*  Retrieving post vars and scrubbing the data
  #****************************************************************************
  if (isset($_POST["rpt_barcode"])) {
    $filterBarcodeNmbr = $_POST["rpt_barcode"];
  } else {
    $filterBarcodeNmbr = 0;
  }
  $newer = $_POST["rpt_newer_year"].'-'.$_POST["rpt_newer_month"].'-'.$_POST["rpt_newer_day"];
  $older = $_POST["rpt_older_year"].'-'.$_POST["rpt_older_month"].'-'.$_POST["rpt_older_day"];
  $sortBy = $_POST["rpt_order_by"];
  $sType = OBIB_SEARCH_BARCODE;

  #****************************************************************************
  #*  Search database for member
  #****************************************************************************
  if (isset($bibid)) {
    $biblioQ = new BiblioSearchQuery();
    $biblioQ->connect();
    $biblio = $biblioQ->get($bibid);
  } else {
    $biblioQ = new BiblioSearchQuery();
    $biblioQ->connect();
    $biblioQ->execAll($sType,$filterBarcodeNmbr,$newer,$older,$sortBy);
  }

  #**************************************************************************
  #*  Show member information
  #**************************************************************************

define('FPDF_FONTPATH','fpdf/font/');

require_once('fpdf/fpdf_thai.php');

###################################Prepare Data###########################################
$j = 0;
while ($biblio = $biblioQ->fetchRow()) {
	if ($biblio->getBarcodeNmbr() <> '') {
		$j++;
		if (strlen(HT($biblio->getTitle())) > 30) {
			$bib_name[$j] = substr(HT($biblio->getTitle()),0,30)."...";
		} else {
			$bib_name[$j] = HT($biblio->getTitle());
		}
		$bib_barcode[$j] = '*'.$biblio->getBarcodeNmbr().'*';
		$bib_barcode_text[$j] = strtoupper ($biblio->getBarcodeNmbr());
		$bib_url[$j] = 'ͧش'.HT(OBIB_LIBRARY_NAME);
	}
}
$bib_page = ceil(sizeof($bib_barcode)/30);
##############################################################################
$pdf=new FPDF_Thai('P', 'mm');

$lineH = 5;

//Data loading
$pdf->AddFont('sarabun','','sarabun.php');
$pdf->AddFont('sarabun','B','sarabunb.php');
$pdf->AddFont('code39jk','','3of9.php');

#$pdf->SetMargins(6, 10, 6);
$pdf->SetAutoPageBreak(false, 10);
###################################################################################################################

for ($page=0; $page<$bib_page; $page++) {

	$pdf->AddPage();
	for ($i=0; $i<10; $i++) {
		$start_pointer = $i*29.52;
		$inner_offset = 5.7;
		$bib_seq = ($i*3)+($page*30);
		$pdf->SetXY(0,$start_pointer+$inner_offset);
		$pdf->SetFont('sarabun','B',8);
		$pdf->Cell(15,3,'',0,0,'L');
		$pdf->Cell(60,3,$bib_url[$bib_seq+1],'',0,'C');
		$pdf->Cell(60,3,$bib_url[$bib_seq+2],'',0,'C');
		$pdf->Cell(60,3,$bib_url[$bib_seq+3],'',0,'C');
		$pdf->Ln();
		$pdf->SetXY(0,$start_pointer+$inner_offset+3.5);
		$pdf->SetFont('code39jk','',25);
		$pdf->Cell(15,$lineH+4,'',0,0,'L');
		$pdf->Cell(60,$lineH+4,$bib_barcode[$bib_seq+1],'',0,'C');
		$pdf->Cell(60,$lineH+4,$bib_barcode[$bib_seq+2],'',0,'C');
		$pdf->Cell(60,$lineH+4,$bib_barcode[$bib_seq+3],'',0,'C');
		$pdf->Ln();
		$pdf->SetXY(0,$start_pointer+$inner_offset+11);
		$pdf->SetFont('sarabun','B',10);
		$pdf->Cell(15,$lineH-3.3,'',0,0,'L');
		$pdf->Cell(60,$lineH-3.3,$bib_barcode_text[$bib_seq+1],'',0,'C');
		$pdf->Cell(60,$lineH-3.3,$bib_barcode_text[$bib_seq+2],'',0,'C');
		$pdf->Cell(60,$lineH-3.3,$bib_barcode_text[$bib_seq+3],'',0,'C');
		$pdf->Ln();
		$pdf->SetXY(0,$start_pointer+$inner_offset+14.5);
		$pdf->SetFont('sarabun','',10);
		$pdf->Cell(15,3,'',0,0,'L');
		$pdf->Cell(60,3,$bib_name[$bib_seq+1],'',0,'C');
		$pdf->Cell(60,3,$bib_name[$bib_seq+2],'',0,'C');
		$pdf->Cell(60,3,$bib_name[$bib_seq+3],'',0,'C');
		$pdf->Ln();
	}
}
//-----------------------------------
$pdf->Output();
ob_end_flush();
?>