<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  $tab = "circulation";

  require_once("../functions/inputFuncs.php");
  require_once("../functions/formatFuncs.php");
  require_once("../shared/logincheck.php");
  require_once("../classes/Member.php");
  require_once("../classes/MemberQuery.php");
  require_once("../classes/BiblioSearch.php");
  require_once("../classes/BiblioSearchQuery.php");
  require_once("../classes/BiblioHold.php");
  require_once("../classes/BiblioHoldQuery.php");
  require_once("../classes/DmQuery.php");
  require_once("../shared/get_form_vars.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);

  #****************************************************************************
  #*  Retrieving get var
  #****************************************************************************
  $mbrid = $_POST["mbrid"];
  if (isset($_GET["msg"])) {
    $msg = "<font class=\"error\">".H($_GET["msg"])."</font><br><br>";
  } else {
    $msg = "";
  }

  #****************************************************************************
  #*  Retrieving post vars and scrubbing the data
  #****************************************************************************
  if (isset($_POST["rpt_barcode"])) {
    $filterBarcodeNmbr = $_POST["rpt_barcode"];
  } else {
    $filterBarcodeNmbr = 0;
  }
  $newer = $_POST["rpt_newer_year"].'-'.$_POST["rpt_newer_month"].'-'.$_POST["rpt_newer_day"];
  $older = $_POST["rpt_older_year"].'-'.$_POST["rpt_older_month"].'-'.$_POST["rpt_older_day"];
  $sortBy = $_POST["rpt_order_by"];
  $sType = OBIB_SEARCH_BARCODE;

  #****************************************************************************
  #*  Loading a few domain tables into associative arrays
  #****************************************************************************
  $dmQ = new DmQuery();
  $dmQ->connect();
  $mbrClassifyDm = $dmQ->getAssoc("mbr_classify_dm");

  #****************************************************************************
  #*  Search database for member
  #****************************************************************************
  if (isset($mbrid)) {
    $mbrQ = new MemberQuery();
    $mbrQ->connect();
    $mbr = $mbrQ->get($mbrid);
  } else {
    $mbrQ = new MemberQuery();
    $mbrQ->connect();
    $mbrQ->execAll($sType,$filterBarcodeNmbr,$newer,$older,$sortBy);
  }

  #**************************************************************************
  #*  Show member information
  #**************************************************************************

define('FPDF_FONTPATH','fpdf/font/');

require_once('fpdf/fpdf_thai.php');

###################################Prepare Data###########################################
$j = 0;
while ($mbr = $mbrQ->fetchMember()) {
	if ($mbr->getBarcodeNmbr() <> '') {
		$j++;
		$mbr_barcode[$j] = $mbr->getBarcodeNmbr();
		$mbr_name[$j] = HT($mbr->getFirstLastName());
		$mbr_createdt[$j] =  substr($mbr->getCreateDt(), 0, 10);
		$mbr_classification[$j] = HT($mbrClassifyDm[$mbr->getClassification()]);
		$mbr_degree[$j] = HT($mbr->getDegree());
		$mbr_image_url[$j] = HT($mbr->getImageURL());
	}
}
$mbr_page = ceil(sizeof($mbr_barcode)/5);
##############################################################################
#$pdf=new FPDF_Thai('P', 'mm', array(85.725,53.975));
$pdf=new FPDF_Thai('P', 'mm');

$initX = 20;
#$initY = 10;
$lineH = 4.8;

//Data loading
#$pdf->AddFont('niramit','','niramit.php');
#$pdf->AddFont('niramit','B','niramitb.php');
$pdf->AddFont('sarabun','','sarabun.php');
$pdf->AddFont('sarabun','B','sarabunb.php');
$pdf->AddFont('3of9','','3of9.php');

$pdf->SetMargins(0, 3);
$pdf->SetAutoPageBreak(false, 10);
###################################################################################################################

for ($page=0; $page<$mbr_page; $page++) {

	$pdf->AddPage();
	for ($i=0; $i<5; $i++) {
		$mbr_seq = $i+1+($page*5);
		$start_pointer = ($i*53.975);
		if ($mbr_barcode[$mbr_seq] <> '') {
			$pdf->SetFont('sarabun','B',20);
			$pdf->SetXY(20,$start_pointer+18);
			$pdf->Cell(85.725,$lineH,'ѵҪԡͧش',0,0,'C');
			$pdf->Ln();
			$pdf->SetFont('sarabun','B',14);
			$pdf->SetXY(20,$start_pointer+24);
			$pdf->Cell(85.725,$lineH,HT(OBIB_LIBRARY_NAME),0,0,'C');
			$pdf->Ln();
			$pdf->SetFont('sarabun','B',16);
			$pdf->SetXY(20,$start_pointer+36);
			$pdf->Cell(24,$lineH,'',0,0,'L');
			$pdf->Cell(60,$lineH,$mbr_name[$mbr_seq],'',0,'L');
			$pdf->Ln();
			$pdf->SetFont('sarabun','B',12);
			$pdf->SetXY(20,$start_pointer+42);
			$pdf->Cell(24,$lineH,'',0,0,'L');
			$pdf->Cell(20,$lineH,'Ҫԡ',0,0,'L');
			$pdf->Cell(40,$lineH,$mbr_classification[$mbr_seq],'',0,'L');
			$pdf->Ln();
			$pdf->SetXY(20,$start_pointer+48);
			$pdf->Cell(24,$lineH,'',0,0,'L');
			$pdf->Cell(24,$lineH,'дѺ/˹',0,0,'L');
			$pdf->Cell(36,$lineH,$mbr_degree[$mbr_seq],'',0,'L');
			$pdf->Ln();
			$pdf->SetXY(20,$start_pointer+54);
			$pdf->Cell(24,$lineH,'',0,0,'L');
			$pdf->Cell(20,$lineH,'ѹ͡ѵ',0,0,'L');
			$pdf->Cell(40,$lineH,$mbr_createdt[$mbr_seq],'',0,'L');
			$pdf->Ln();
			$pdf->SetFont('sarabun','B',16);
			$pdf->SetXY($initX+85.725,$start_pointer+20);
			$pdf->Cell(85.725,$lineH,'͹䢡ѵҪԡ',0,0,'C');
			$pdf->Ln();
			$pdf->SetFont('sarabun','B',12);
			$pdf->SetXY($initX+85.725,$start_pointer+26);
			$pdf->Cell(85.725,$lineH,'  1.  ʴѵ÷ء/׹Ѿҡͧش',0,0,'L');
			$pdf->Ln();
			$pdf->SetXY($initX+85.725,$start_pointer+32);
			$pdf->Cell(85.725,$lineH,'  2.  óպѵ٭µͧ¤ҸӺѵ',0,0,'L');
			$pdf->Ln();
			$pdf->SetXY($initX+85.725,$start_pointer+38);
			$pdf->Cell(85.725,$lineH,'  3.  ѵù੾Ңͧѵҹ',0,0,'L');
			$pdf->Ln();
			$pdf->SetFont('3of9','',25);
			$pdf->SetXY($initX+85.725,$start_pointer+46);
			$pdf->Cell(85.725,$lineH+$lineH,'*'.$mbr_barcode[$mbr_seq].'*',0,0,'C');
			$pdf->Ln();
			$pdf->SetFont('sarabun','B',14);
			$pdf->SetXY($initX+85.725,$start_pointer+53);
			$pdf->Cell(85.725,$lineH+$lineH,'Ţѵ  '.$mbr_barcode[$mbr_seq],0,0,'C');
			$pdf->Ln();
			$pdf->Rect($initX,$start_pointer+15,85.725,53.975);
			$pdf->Rect($initX+85.725,$start_pointer+15,85.725,53.975);
			if (($mbr_image_url[$mbr_seq] <> '') && file_exists("../".MEMBER_PATH."/".$mbr_image_url[$mbr_seq])){
				$pdf->Image("../".MEMBER_PATH."/".$mbr_image_url[$mbr_seq],$initX+3.25,$start_pointer+15+22.2,19.5);# ٻ
			} else {
				$pdf->Rect($initX+3,$start_pointer+15+22,20,28);# ͺٻ
			}
		}
	}
}
//-----------------------------------
$pdf->Output();
ob_end_flush();
?>