<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
  require_once("../shared/common.php");
  $tab = "utilities";

  require_once("../functions/inputFuncs.php");
  require_once("../functions/formatFuncs.php");
  require_once("../shared/logincheck.php");
  require_once("../classes/BiblioSearch.php");
  require_once("../classes/BiblioSearchQuery.php");
  require_once("../functions/searchFuncs.php");
  require_once("../classes/DmQuery.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);

  #****************************************************************************
  #*  Retrieving get var
  #****************************************************************************
  $bibid = $_POST["bibid"];
  if (isset($_GET["msg"])) {
    $msg = "<font class=\"error\">".H($_GET["msg"])."</font><br><br>";
  } else {
    $msg = "";
  }

  #****************************************************************************
  #*  Retrieving post vars and scrubbing the data
  #****************************************************************************
  if (isset($_POST["rpt_barcode"])) {
    $filterBarcodeNmbr = $_POST["rpt_barcode"];
  } else {
    $filterBarcodeNmbr = 0;
  }
  $newer = $_POST["rpt_newer_year"].'-'.$_POST["rpt_newer_month"].'-'.$_POST["rpt_newer_day"];
  $older = $_POST["rpt_older_year"].'-'.$_POST["rpt_older_month"].'-'.$_POST["rpt_older_day"];
  $sortBy = $_POST["rpt_order_by"];
  $sType = OBIB_SEARCH_BARCODE;

  #****************************************************************************
  #*  Search database for member
  #****************************************************************************
  if (isset($bibid)) {
    $biblioQ = new BiblioSearchQuery();
    $biblioQ->connect();
    $biblio = $biblioQ->get($bibid);
  } else {
    $biblioQ = new BiblioSearchQuery();
    $biblioQ->connect();
    $biblioQ->execAll($sType,$filterBarcodeNmbr,$newer,$older,$sortBy);
  }

  #**************************************************************************
  #*  Show member information
  #**************************************************************************

define('FPDF_FONTPATH','fpdf/font/');

require_once('fpdf/fpdf_thai.php');

###################################Prepare Data###########################################
$j = 0;
while ($biblio = $biblioQ->fetchRow()) {
	if ($biblio->getBarcodeNmbr() <> '') {
		$j++;
		if (trim($biblio->getCallNmbr3()) <> "") {
			$bib_barcode[$j] = '*'.$biblio->getBarcodeNmbr().'*';
			$bib_callnmbr1[$j] = HT($biblio->getCallNmbr1());
			$bib_callnmbr2[$j] = HT($biblio->getCallNmbr2());
			$bib_callnmbr3[$j] = HT($biblio->getCallNmbr3());
			$bib_callnmbr4[$j] = '.'.$biblio->getCopyId();
		} else {
			$bib_barcode[$j] = '*'.$biblio->getBarcodeNmbr().'*';
			$bib_callnmbr1[$j] = HT($biblio->getCallNmbr1());
			$bib_callnmbr2[$j] = HT($biblio->getCallNmbr2());
			$bib_callnmbr3[$j] = '.'.$biblio->getCopyId();
			$bib_callnmbr4[$j] = '';
		}
	}
}
$bib_page = ceil(sizeof($bib_barcode)/50);
##############################################################################
$pdf=new FPDF_Thai('P', 'mm');

$lineH = 7;

//Data loading
$pdf->AddFont('niramit','B','niramitb.php');

#$pdf->SetMargins(6, 10, 6);
$pdf->SetAutoPageBreak(false, 10);
###################################################################################################################

for ($page=0; $page<$bib_page; $page++) {

	$pdf->AddPage();
	for ($i=0; $i<10; $i++) {
		$start_pointer = $i*29.7;
		$bib_seq = ($i*5)+($page*50);
		$pdf->SetFont('niramit','B',14);
		$pdf->SetXY(0,$start_pointer+4);
#		$pdf->Cell(2.5,$lineH,'',0,0,'L');
		$pdf->Cell(9.5,$lineH,'',0,0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr1[$bib_seq+1],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr1[$bib_seq+2],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr1[$bib_seq+3],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr1[$bib_seq+4],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr1[$bib_seq+5],'',0,'L');
		$pdf->Ln();
		$pdf->SetXY(0,$start_pointer+9);
		$pdf->Cell(9.5,$lineH,'',0,0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr2[$bib_seq+1],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr2[$bib_seq+2],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr2[$bib_seq+3],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr2[$bib_seq+4],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr2[$bib_seq+5],'',0,'L');
		$pdf->Ln();
		$pdf->SetXY(0,$start_pointer+14);
		$pdf->Cell(9.5,$lineH,'',0,0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr3[$bib_seq+1],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr3[$bib_seq+2],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr3[$bib_seq+3],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr3[$bib_seq+4],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr3[$bib_seq+5],'',0,'L');
		$pdf->Ln();
		$pdf->SetXY(0,$start_pointer+19);
		$pdf->Cell(9.5,$lineH,'',0,0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr4[$bib_seq+1],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr4[$bib_seq+2],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr4[$bib_seq+3],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr4[$bib_seq+4],'',0,'L');
		$pdf->Cell(41,$lineH,$bib_callnmbr4[$bib_seq+5],'',0,'L');
		$pdf->Ln();
	}
}
//-----------------------------------
$pdf->Output();
ob_end_flush();
?>